rule win_webc2_yahoo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.webc2_yahoo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webc2_yahoo"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d443802 50 e8???????? 56 e8???????? ff750c }
            // n = 6, score = 100
            //   8d443802             | lea                 eax, [eax + edi + 2]
            //   50                   | push                eax
            //   e8????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_1 = { ffb69c841e00 ff15???????? 85c0 7506 53 }
            // n = 5, score = 100
            //   ffb69c841e00         | push                dword ptr [esi + 0x1e849c]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7506                 | jne                 8
            //   53                   | push                ebx

        $sequence_2 = { e8???????? 015d0c 03f3 83c428 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   015d0c               | add                 dword ptr [ebp + 0xc], ebx
            //   03f3                 | add                 esi, ebx
            //   83c428               | add                 esp, 0x28

        $sequence_3 = { ffb694841e00 ffd3 57 e8???????? 59 }
            // n = 5, score = 100
            //   ffb694841e00         | push                dword ptr [esi + 0x1e8494]
            //   ffd3                 | call                ebx
            //   57                   | push                edi
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_4 = { 83ec64 8b4d08 56 57 68???????? 6a01 }
            // n = 6, score = 100
            //   83ec64               | sub                 esp, 0x64
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   56                   | push                esi
            //   57                   | push                edi
            //   68????????           |                     
            //   6a01                 | push                1

        $sequence_5 = { e8???????? 6a04 68???????? ff750c ff15???????? }
            // n = 5, score = 100
            //   e8????????           |                     
            //   6a04                 | push                4
            //   68????????           |                     
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff15????????         |                     

        $sequence_6 = { 85c0 0f84b4000000 8d85fcfeffff 56 50 8d85fcfeffff }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   0f84b4000000         | je                  0xba
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   56                   | push                esi
            //   50                   | push                eax
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]

        $sequence_7 = { 8d85c8fdffff 56 50 e8???????? 83c418 }
            // n = 5, score = 100
            //   8d85c8fdffff         | lea                 eax, [ebp - 0x238]
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18

        $sequence_8 = { 8b7518 83c414 8d85fcd7ffff 8bcb }
            // n = 4, score = 100
            //   8b7518               | mov                 esi, dword ptr [ebp + 0x18]
            //   83c414               | add                 esp, 0x14
            //   8d85fcd7ffff         | lea                 eax, [ebp - 0x2804]
            //   8bcb                 | mov                 ecx, ebx

        $sequence_9 = { b838280000 e8???????? 53 56 }
            // n = 4, score = 100
            //   b838280000           | mov                 eax, 0x2838
            //   e8????????           |                     
            //   53                   | push                ebx
            //   56                   | push                esi

    condition:
        7 of them and filesize < 8060928
}