rule win_webmonitor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.webmonitor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.webmonitor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c9 c1eb0a 41 0fb7c3 }
            // n = 4, score = 200
            //   33c9                 | xor                 ecx, ecx
            //   c1eb0a               | shr                 ebx, 0xa
            //   41                   | inc                 ecx
            //   0fb7c3               | movzx               eax, bx

        $sequence_1 = { 04f0 fd ff01 04f0 fd }
            // n = 5, score = 200
            //   04f0                 | add                 al, 0xf0
            //   fd                   | std                 
            //   ff01                 | inc                 dword ptr [ecx]
            //   04f0                 | add                 al, 0xf0
            //   fd                   | std                 

        $sequence_2 = { 50 51 e8???????? 83c418 807c242000 }
            // n = 5, score = 200
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   807c242000           | cmp                 byte ptr [esp + 0x20], 0

        $sequence_3 = { 0fb6c0 6a09 33f0 e8???????? }
            // n = 4, score = 200
            //   0fb6c0               | movzx               eax, al
            //   6a09                 | push                9
            //   33f0                 | xor                 esi, eax
            //   e8????????           |                     

        $sequence_4 = { 2b49fc e9???????? 55 8bec f30f104508 ff750c }
            // n = 6, score = 200
            //   2b49fc               | sub                 ecx, dword ptr [ecx - 4]
            //   e9????????           |                     
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   f30f104508           | movss               xmm0, dword ptr [ebp + 8]
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_5 = { 0f4345d8 0fbe0408 03d8 e9???????? 03da 8a043b }
            // n = 6, score = 200
            //   0f4345d8             | cmovae              eax, dword ptr [ebp - 0x28]
            //   0fbe0408             | movsx               eax, byte ptr [eax + ecx]
            //   03d8                 | add                 ebx, eax
            //   e9????????           |                     
            //   03da                 | add                 ebx, edx
            //   8a043b               | mov                 al, byte ptr [ebx + edi]

        $sequence_6 = { 0080cd41009c d34100 e8???????? a3???????? 41 }
            // n = 5, score = 200
            //   0080cd41009c         | add                 byte ptr [eax - 0x63ffbe33], al
            //   d34100               | rol                 dword ptr [ecx], cl
            //   e8????????           |                     
            //   a3????????           |                     
            //   41                   | inc                 ecx

        $sequence_7 = { 1b4300 38644400 44 8a4100 }
            // n = 4, score = 200
            //   1b4300               | sbb                 eax, dword ptr [ebx]
            //   38644400             | cmp                 byte ptr [esp + eax*2], ah
            //   44                   | inc                 esp
            //   8a4100               | mov                 al, byte ptr [ecx]

        $sequence_8 = { 2503fd006c ff1e e00e 000e }
            // n = 4, score = 200
            //   2503fd006c           | and                 eax, 0x6c00fd03
            //   ff1e                 | lcall               [esi]
            //   e00e                 | loopne              0x10
            //   000e                 | add                 byte ptr [esi], cl

        $sequence_9 = { 03c6 53 c1e008 6a0e 8945e0 e8???????? }
            // n = 6, score = 200
            //   03c6                 | add                 eax, esi
            //   53                   | push                ebx
            //   c1e008               | shl                 eax, 8
            //   6a0e                 | push                0xe
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   e8????????           |                     

        $sequence_10 = { 04c8 fe04fc fd 04f8 fd ff01 }
            // n = 6, score = 200
            //   04c8                 | add                 al, 0xc8
            //   fe04fc               | inc                 byte ptr [esp + edi*8]
            //   fd                   | std                 
            //   04f8                 | add                 al, 0xf8
            //   fd                   | std                 
            //   ff01                 | inc                 dword ptr [ecx]

        $sequence_11 = { 41 00baa4f34100 b9???????? ffe1 ba???????? b9???????? ffe1 }
            // n = 7, score = 200
            //   41                   | inc                 ecx
            //   00baa4f34100         | add                 byte ptr [edx + 0x41f3a4], bh
            //   b9????????           |                     
            //   ffe1                 | jmp                 ecx
            //   ba????????           |                     
            //   b9????????           |                     
            //   ffe1                 | jmp                 ecx

        $sequence_12 = { 04f8 fd 0512002413 000d???????? 04f4 }
            // n = 5, score = 200
            //   04f8                 | add                 al, 0xf8
            //   fd                   | std                 
            //   0512002413           | add                 eax, 0x13240012
            //   000d????????         |                     
            //   04f4                 | add                 al, 0xf4

        $sequence_13 = { 33cd e8???????? c9 c3 68???????? e8???????? }
            // n = 6, score = 200
            //   33cd                 | xor                 ecx, ebp
            //   e8????????           |                     
            //   c9                   | leave               
            //   c3                   | ret                 
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_14 = { 33c9 6800900100 668908 8bcf }
            // n = 4, score = 200
            //   33c9                 | xor                 ecx, ecx
            //   6800900100           | push                0x19000
            //   668908               | mov                 word ptr [eax], cx
            //   8bcf                 | mov                 ecx, edi

        $sequence_15 = { 61 0043ec fe04ec fe05???????? 000d???????? 04c8 }
            // n = 6, score = 200
            //   61                   | popal               
            //   0043ec               | add                 byte ptr [ebx - 0x14], al
            //   fe04ec               | inc                 byte ptr [esp + ebp*8]
            //   fe05????????         |                     
            //   000d????????         |                     
            //   04c8                 | add                 al, 0xc8

    condition:
        7 of them and filesize < 1984512
}