rule win_whiskerspy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.whiskerspy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.whiskerspy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b06 8bcf d3e8 a801 }
            // n = 4, score = 300
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8bcf                 | mov                 ecx, edi
            //   d3e8                 | shr                 eax, cl
            //   a801                 | test                al, 1

        $sequence_1 = { 33d2 488d4c2460 41b804010000 e8???????? 33d2 }
            // n = 5, score = 200
            //   33d2                 | dec                 eax
            //   488d4c2460           | lea                 ebp, [esp - 0x338]
            //   41b804010000         | dec                 eax
            //   e8????????           |                     
            //   33d2                 | sub                 esp, 0x438

        $sequence_2 = { 418b37 488bfd 488b8c2420010000 4883c510 }
            // n = 4, score = 200
            //   418b37               | xor                 edi, eax
            //   488bfd               | dec                 ebx
            //   488b8c2420010000     | xchg                dword ptr [esi + edi*8 + 0x274e0], edi
            //   4883c510             | xor                 eax, eax

        $sequence_3 = { 44896ddc 498bd4 498bcd e8???????? 4c8be0 }
            // n = 5, score = 200
            //   44896ddc             | inc                 esp
            //   498bd4               | mov                 dword ptr [ebp - 0x24], ebp
            //   498bcd               | dec                 ecx
            //   e8????????           |                     
            //   4c8be0               | mov                 edx, esp

        $sequence_4 = { 4803ca 418bc3 4c3bc1 458b4210 8b0d???????? }
            // n = 5, score = 200
            //   4803ca               | dec                 eax
            //   418bc3               | mov                 ebx, dword ptr [esp + 0x50]
            //   4c3bc1               | inc                 ecx
            //   458b4210             | push                edi
            //   8b0d????????         |                     

        $sequence_5 = { 48d3cf 4933f8 4b87bcfee0740200 33c0 488b5c2450 }
            // n = 5, score = 200
            //   48d3cf               | mov                 esp, eax
            //   4933f8               | mov                 byte ptr [edi + esi], 0
            //   4b87bcfee0740200     | dec                 eax
            //   33c0                 | lea                 edx, [ebp - 0x20]
            //   488b5c2450           | dec                 ecx

        $sequence_6 = { e8???????? c6043700 488d55e0 498bce e8???????? }
            // n = 5, score = 200
            //   e8????????           |                     
            //   c6043700             | dec                 ecx
            //   488d55e0             | mov                 ecx, ebp
            //   498bce               | dec                 esp
            //   e8????????           |                     

        $sequence_7 = { 4157 488dac24c8fcffff 4881ec38040000 488bda }
            // n = 4, score = 200
            //   4157                 | mov                 ecx, esi
            //   488dac24c8fcffff     | dec                 eax
            //   4881ec38040000       | ror                 edi, cl
            //   488bda               | dec                 ecx

        $sequence_8 = { 8d45d4 837de808 8b4db0 0f4345d4 8b16 }
            // n = 5, score = 100
            //   8d45d4               | cmp                 eax, ecx
            //   837de808             | inc                 ebp
            //   8b4db0               | mov                 eax, dword ptr [edx + 0x10]
            //   0f4345d4             | xor                 edx, edx
            //   8b16                 | dec                 eax

        $sequence_9 = { c685f9fbffff1e c685fafbffff8b 59 c685fbfbffff86 }
            // n = 4, score = 100
            //   c685f9fbffff1e       | add                 ecx, edx
            //   c685fafbffff8b       | inc                 ecx
            //   59                   | mov                 eax, ebx
            //   c685fbfbffff86       | dec                 esp

        $sequence_10 = { c685e4feffff7b 889de5feffff 8a85b8feffff 8a840db8feffff }
            // n = 4, score = 100
            //   c685e4feffff7b       | mov                 ecx, dword ptr [esp + 0x120]
            //   889de5feffff         | dec                 eax
            //   8a85b8feffff         | add                 ebp, 0x10
            //   8a840db8feffff       | dec                 eax

        $sequence_11 = { 6a06 59 f3a5 8b75e8 8b7dd8 }
            // n = 5, score = 100
            //   6a06                 | mov                 ebx, dword ptr [esp + 0x50]
            //   59                   | inc                 ecx
            //   f3a5                 | push                edi
            //   8b75e8               | dec                 eax
            //   8b7dd8               | lea                 ebp, [esp - 0x338]

        $sequence_12 = { 0fbec1 83e820 83e07f 8b0cc5d43b4300 eb02 }
            // n = 5, score = 100
            //   0fbec1               | dec                 eax
            //   83e820               | sub                 esp, 0x438
            //   83e07f               | dec                 eax
            //   8b0cc5d43b4300       | mov                 ebx, edx
            //   eb02                 | inc                 ecx

        $sequence_13 = { 7430 8b5304 8d47f8 8d7308 }
            // n = 4, score = 100
            //   7430                 | mov                 esi, dword ptr [edi]
            //   8b5304               | dec                 eax
            //   8d47f8               | mov                 edi, ebp
            //   8d7308               | dec                 eax

        $sequence_14 = { 33c0 f68594f9ffff02 899d9cf8ffff 89b5a0f8ffff }
            // n = 4, score = 100
            //   33c0                 | dec                 ebx
            //   f68594f9ffff02       | xchg                dword ptr [esi + edi*8 + 0x274e0], edi
            //   899d9cf8ffff         | xor                 eax, eax
            //   89b5a0f8ffff         | dec                 eax

    condition:
        7 of them and filesize < 591872
}