rule win_whiteblackcrypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.whiteblackcrypt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.whiteblackcrypt"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 40326c243e 31ef 4131fa 4531d6 4531f5 }
            // n = 5, score = 100
            //   40326c243e           | mov                 eax, esp
            //   31ef                 | dec                 eax
            //   4131fa               | mov                 edx, edi
            //   4531d6               | cmp                 dword ptr [ecx], 6
            //   4531f5               | ja                  0x9e7

        $sequence_1 = { 7477 83feff 7c60 752e 488b8b38020000 }
            // n = 5, score = 100
            //   7477                 | mov                 al, byte ptr [ebx + 1]
            //   83feff               | inc                 ecx
            //   7c60                 | mov                 byte ptr [ebx + 1], dl
            //   752e                 | inc                 ecx
            //   488b8b38020000       | mov                 dl, byte ptr [ebx + 9]

        $sequence_2 = { 410f94c2 4409d0 4109cb 753a }
            // n = 4, score = 100
            //   410f94c2             | dec                 eax
            //   4409d0               | mov                 edi, ecx
            //   4109cb               | dec                 eax
            //   753a                 | mov                 ecx, eax

        $sequence_3 = { ff15???????? 83f812 0f84d4000000 488b8b38020000 e8???????? 48c7c0ffffffff }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   83f812               | mov                 dl, byte ptr [ebx + eax]
            //   0f84d4000000         | inc                 ebx
            //   488b8b38020000       | mov                 al, byte ptr [ebx + ecx]
            //   e8????????           |                     
            //   48c7c0ffffffff       | inc                 ebp

        $sequence_4 = { 0f840c010000 488d7c2420 4889da 41b804010000 4889f9 }
            // n = 5, score = 100
            //   0f840c010000         | pop                 esi
            //   488d7c2420           | ret                 
            //   4889da               | dec                 esp
            //   41b804010000         | lea                 ecx, [edx + 0x10]
            //   4889f9               | pop                 ebx

        $sequence_5 = { 4889c1 e8???????? 4889e9 4889c2 4883c428 5b }
            // n = 6, score = 100
            //   4889c1               | and                 ax, 0xf000
            //   e8????????           |                     
            //   4889e9               | cmp                 ax, 0x4000
            //   4889c2               | sete                dl
            //   4883c428             | nop                 
            //   5b                   | mulsd               xmm0, xmm0

        $sequence_6 = { 0f84d4000000 488b8b38020000 e8???????? 48c7c0ffffffff 48898338020000 }
            // n = 5, score = 100
            //   0f84d4000000         | cmp                 ax, 0x4000
            //   488b8b38020000       | sete                dl
            //   e8????????           |                     
            //   48c7c0ffffffff       | mov                 eax, edx
            //   48898338020000       | dec                 eax

        $sequence_7 = { 4c89e1 41c6442cff00 e8???????? 4c39e6 }
            // n = 4, score = 100
            //   4c89e1               | mov                 ecx, 0x80000001
            //   41c6442cff00         | dec                 eax
            //   e8????????           |                     
            //   4c39e6               | mov                 dword ptr [esp + 0x20], eax

        $sequence_8 = { 4889f1 e8???????? 4889f1 85c0 7407 }
            // n = 5, score = 100
            //   4889f1               | je                  0x21b
            //   e8????????           |                     
            //   4889f1               | cmp                 byte ptr [ebx], 0
            //   85c0                 | je                  0x1dc
            //   7407                 | dec                 eax

        $sequence_9 = { 4401e6 4d63c4 4889f9 4989d9 ba01000000 }
            // n = 5, score = 100
            //   4401e6               | mov                 dword ptr [esp + 0x38], 0x190
            //   4d63c4               | mov                 dword ptr [esp + 0x30], 0x190
            //   4889f9               | cdq                 
            //   4989d9               | mov                 edx, dword ptr [esp + 0x3c]
            //   ba01000000           | pxor                xmm3, xmm3

    condition:
        7 of them and filesize < 99328
}