rule win_winsloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.winsloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.winsloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83c40c a4 ffd0 5b 5f }
            // n = 5, score = 200
            //   83c40c               | add                 esp, 0xc
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   ffd0                 | call                eax
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi

        $sequence_1 = { 83c434 85ff 7510 56 e8???????? 83c404 33c0 }
            // n = 7, score = 200
            //   83c434               | add                 esp, 0x34
            //   85ff                 | test                edi, edi
            //   7510                 | jne                 0x12
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   33c0                 | xor                 eax, eax

        $sequence_2 = { 8d5c3304 e8???????? 8b0d???????? 8b15???????? 6689841dfcfbffff }
            // n = 5, score = 200
            //   8d5c3304             | lea                 ebx, [ebx + esi + 4]
            //   e8????????           |                     
            //   8b0d????????         |                     
            //   8b15????????         |                     
            //   6689841dfcfbffff     | mov                 word ptr [ebp + ebx - 0x404], ax

        $sequence_3 = { b8???????? 83c40c 66c7843500fcfffff90b 8d4801 8d4900 }
            // n = 5, score = 200
            //   b8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   66c7843500fcfffff90b     | mov    word ptr [ebp + esi - 0x400], 0xbf9
            //   8d4801               | lea                 ecx, [eax + 1]
            //   8d4900               | lea                 ecx, [ecx]

        $sequence_4 = { 75f9 2bc1 0fb6f8 888435fefbffff 8d4701 50 }
            // n = 6, score = 200
            //   75f9                 | jne                 0xfffffffb
            //   2bc1                 | sub                 eax, ecx
            //   0fb6f8               | movzx               edi, al
            //   888435fefbffff       | mov                 byte ptr [ebp + esi - 0x402], al
            //   8d4701               | lea                 eax, [edi + 1]
            //   50                   | push                eax

        $sequence_5 = { 8d44020c 0fb6f9 66898435fefbffff 888c3500fcffff 8d4f01 51 8d943501fcffff }
            // n = 7, score = 200
            //   8d44020c             | lea                 eax, [edx + eax + 0xc]
            //   0fb6f9               | movzx               edi, cl
            //   66898435fefbffff     | mov                 word ptr [ebp + esi - 0x402], ax
            //   888c3500fcffff       | mov                 byte ptr [ebp + esi - 0x400], cl
            //   8d4f01               | lea                 ecx, [edi + 1]
            //   51                   | push                ecx
            //   8d943501fcffff       | lea                 edx, [ebp + esi - 0x3ff]

        $sequence_6 = { 50 e8???????? 68???????? 8d5c3304 }
            // n = 4, score = 200
            //   50                   | push                eax
            //   e8????????           |                     
            //   68????????           |                     
            //   8d5c3304             | lea                 ebx, [ebx + esi + 4]

        $sequence_7 = { 83c40c 03f7 b8???????? 66c78435fcfbffff9001 8d4801 8a10 40 }
            // n = 7, score = 200
            //   83c40c               | add                 esp, 0xc
            //   03f7                 | add                 esi, edi
            //   b8????????           |                     
            //   66c78435fcfbffff9001     | mov    word ptr [ebp + esi - 0x404], 0x190
            //   8d4801               | lea                 ecx, [eax + 1]
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   40                   | inc                 eax

        $sequence_8 = { 83c40c 6800040000 8d8dfcf7ffff 51 }
            // n = 4, score = 200
            //   83c40c               | add                 esp, 0xc
            //   6800040000           | push                0x400
            //   8d8dfcf7ffff         | lea                 ecx, [ebp - 0x804]
            //   51                   | push                ecx

        $sequence_9 = { 8d8dfcf7ffff e8???????? 85c0 7507 33c0 }
            // n = 5, score = 100
            //   8d8dfcf7ffff         | lea                 ecx, [ebp - 0x804]
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   33c0                 | xor                 eax, eax

        $sequence_10 = { 894df0 8b34cdb86a0110 8b4d08 6a5a 2bce 5b }
            // n = 6, score = 100
            //   894df0               | mov                 dword ptr [ebp - 0x10], ecx
            //   8b34cdb86a0110       | mov                 esi, dword ptr [ecx*8 + 0x10016ab8]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   6a5a                 | push                0x5a
            //   2bce                 | sub                 ecx, esi
            //   5b                   | pop                 ebx

        $sequence_11 = { 7466 40 68???????? 50 e8???????? 83c408 }
            // n = 6, score = 100
            //   7466                 | je                  0x68
            //   40                   | inc                 eax
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8

        $sequence_12 = { 57 8db8b0c20110 57 ff15???????? ff0d???????? }
            // n = 5, score = 100
            //   57                   | push                edi
            //   8db8b0c20110         | lea                 edi, [eax + 0x1001c2b0]
            //   57                   | push                edi
            //   ff15????????         |                     
            //   ff0d????????         |                     

        $sequence_13 = { 8b85f8f3ffff c68405fcfbffff0b 8b8df8f3ffff 83c101 898df8f3ffff }
            // n = 5, score = 100
            //   8b85f8f3ffff         | mov                 eax, dword ptr [ebp - 0xc08]
            //   c68405fcfbffff0b     | mov                 byte ptr [ebp + eax - 0x404], 0xb
            //   8b8df8f3ffff         | mov                 ecx, dword ptr [ebp - 0xc08]
            //   83c101               | add                 ecx, 1
            //   898df8f3ffff         | mov                 dword ptr [ebp - 0xc08], ecx

        $sequence_14 = { 0f84ee020000 66660f1f840000000000 81f900010000 0f8587000000 8bce }
            // n = 5, score = 100
            //   0f84ee020000         | je                  0x2f4
            //   66660f1f840000000000     | nop    word ptr [eax + eax]
            //   81f900010000         | cmp                 ecx, 0x100
            //   0f8587000000         | jne                 0x8d
            //   8bce                 | mov                 ecx, esi

        $sequence_15 = { 1bc0 23c1 83c008 5d c3 8b04c50c480110 5d }
            // n = 7, score = 100
            //   1bc0                 | sbb                 eax, eax
            //   23c1                 | and                 eax, ecx
            //   83c008               | add                 eax, 8
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8b04c50c480110       | mov                 eax, dword ptr [eax*8 + 0x1001480c]
            //   5d                   | pop                 ebp

    condition:
        7 of them and filesize < 270336
}