rule win_wndtest_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.wndtest."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wndtest"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89461c 8907 894704 894708 89470c 894710 }
            // n = 6, score = 400
            //   89461c               | mov                 dword ptr [esi + 0x1c], eax
            //   8907                 | mov                 dword ptr [edi], eax
            //   894704               | mov                 dword ptr [edi + 4], eax
            //   894708               | mov                 dword ptr [edi + 8], eax
            //   89470c               | mov                 dword ptr [edi + 0xc], eax
            //   894710               | mov                 dword ptr [edi + 0x10], eax

        $sequence_1 = { 8945fc eb03 8b45fc 8b5d08 }
            // n = 4, score = 400
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   eb03                 | jmp                 5
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]

        $sequence_2 = { 53 6a00 ff15???????? 6a0d ff15???????? }
            // n = 5, score = 400
            //   53                   | push                ebx
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   6a0d                 | push                0xd
            //   ff15????????         |                     

        $sequence_3 = { 8b4de8 41 51 e8???????? 83c404 }
            // n = 5, score = 400
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   41                   | inc                 ecx
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_4 = { 5e 8be5 5d c3 880c3e 5f 5e }
            // n = 7, score = 400
            //   5e                   | pop                 esi
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   880c3e               | mov                 byte ptr [esi + edi], cl
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_5 = { 6805010000 e8???????? 83c404 6804010000 8bd8 53 6a00 }
            // n = 7, score = 400
            //   6805010000           | push                0x105
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   6804010000           | push                0x104
            //   8bd8                 | mov                 ebx, eax
            //   53                   | push                ebx
            //   6a00                 | push                0

        $sequence_6 = { 33c9 8d460a ba02000000 f7e2 0f90c1 f7d9 }
            // n = 6, score = 400
            //   33c9                 | xor                 ecx, ecx
            //   8d460a               | lea                 eax, [esi + 0xa]
            //   ba02000000           | mov                 edx, 2
            //   f7e2                 | mul                 edx
            //   0f90c1               | seto                cl
            //   f7d9                 | neg                 ecx

        $sequence_7 = { 50 56 ffd7 a3???????? 8b0d???????? 8b15???????? }
            // n = 6, score = 400
            //   50                   | push                eax
            //   56                   | push                esi
            //   ffd7                 | call                edi
            //   a3????????           |                     
            //   8b0d????????         |                     
            //   8b15????????         |                     

        $sequence_8 = { 46 895dfc 3b750c 7cbe 5f }
            // n = 5, score = 400
            //   46                   | inc                 esi
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   3b750c               | cmp                 esi, dword ptr [ebp + 0xc]
            //   7cbe                 | jl                  0xffffffc0
            //   5f                   | pop                 edi

        $sequence_9 = { c3 880c3e 5f 5e }
            // n = 4, score = 400
            //   c3                   | ret                 
            //   880c3e               | mov                 byte ptr [esi + edi], cl
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

    condition:
        7 of them and filesize < 901120
}