rule win_woody_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.woody."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.woody"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 83e103 c744241004010000 f3a4 bfc0a60110 83c9ff f2ae }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   83e103               | and                 ecx, 3
            //   c744241004010000     | mov                 dword ptr [esp + 0x10], 0x104
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   bfc0a60110           | mov                 edi, 0x1001a6c0
            //   83c9ff               | or                  ecx, 0xffffffff
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

        $sequence_1 = { 8d4ddc 51 ff75e8 50 ff15???????? 85c0 0f8417010000 }
            // n = 7, score = 100
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   51                   | push                ecx
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8417010000         | je                  0x11d

        $sequence_2 = { 83c008 83c308 3b4510 75e7 8b4604 50 894508 }
            // n = 7, score = 100
            //   83c008               | add                 eax, 8
            //   83c308               | add                 ebx, 8
            //   3b4510               | cmp                 eax, dword ptr [ebp + 0x10]
            //   75e7                 | jne                 0xffffffe9
            //   8b4604               | mov                 eax, dword ptr [esi + 4]
            //   50                   | push                eax
            //   894508               | mov                 dword ptr [ebp + 8], eax

        $sequence_3 = { 5d 5b c20800 8b5114 8b690c 8b4910 8bc2 }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   c20800               | ret                 8
            //   8b5114               | mov                 edx, dword ptr [ecx + 0x14]
            //   8b690c               | mov                 ebp, dword ptr [ecx + 0xc]
            //   8b4910               | mov                 ecx, dword ptr [ecx + 0x10]
            //   8bc2                 | mov                 eax, edx

        $sequence_4 = { ff15???????? 85c0 7404 b001 5e c3 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7404                 | je                  6
            //   b001                 | mov                 al, 1
            //   5e                   | pop                 esi
            //   c3                   | ret                 

        $sequence_5 = { 83c408 85f6 751e 68ee050000 50 }
            // n = 5, score = 100
            //   83c408               | add                 esp, 8
            //   85f6                 | test                esi, esi
            //   751e                 | jne                 0x20
            //   68ee050000           | push                0x5ee
            //   50                   | push                eax

        $sequence_6 = { 5e 83c2fc 895508 895108 5d c20400 55 }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   83c2fc               | add                 edx, -4
            //   895508               | mov                 dword ptr [ebp + 8], edx
            //   895108               | mov                 dword ptr [ecx + 8], edx
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   55                   | push                ebp

        $sequence_7 = { 89742458 0f8c78ffffff 8b442454 8d0c92 8b542448 5f c1e102 }
            // n = 7, score = 100
            //   89742458             | mov                 dword ptr [esp + 0x58], esi
            //   0f8c78ffffff         | jl                  0xffffff7e
            //   8b442454             | mov                 eax, dword ptr [esp + 0x54]
            //   8d0c92               | lea                 ecx, [edx + edx*4]
            //   8b542448             | mov                 edx, dword ptr [esp + 0x48]
            //   5f                   | pop                 edi
            //   c1e102               | shl                 ecx, 2

        $sequence_8 = { 8ba880000000 85ed 0f84ae000000 8b8884000000 85c9 0f84a0000000 8b443d10 }
            // n = 7, score = 100
            //   8ba880000000         | mov                 ebp, dword ptr [eax + 0x80]
            //   85ed                 | test                ebp, ebp
            //   0f84ae000000         | je                  0xb4
            //   8b8884000000         | mov                 ecx, dword ptr [eax + 0x84]
            //   85c9                 | test                ecx, ecx
            //   0f84a0000000         | je                  0xa6
            //   8b443d10             | mov                 eax, dword ptr [ebp + edi + 0x10]

        $sequence_9 = { 85c0 7447 6a10 8d45e0 6a00 50 e8???????? }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7447                 | je                  0x49
            //   6a10                 | push                0x10
            //   8d45e0               | lea                 eax, [ebp - 0x20]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 409600
}