rule win_woolger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.woolger."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.woolger"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 46 8b5510 52 6a00 ff15???????? }
            // n = 5, score = 200
            //   46                   | inc                 esi
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]
            //   52                   | push                edx
            //   6a00                 | push                0
            //   ff15????????         |                     

        $sequence_1 = { ff15???????? 6800040000 8bf0 e8???????? 83c404 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   6800040000           | push                0x400
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_2 = { 0f84e6000000 3da5000000 0f84db000000 83f85b 0f84cb000000 }
            // n = 5, score = 200
            //   0f84e6000000         | je                  0xec
            //   3da5000000           | cmp                 eax, 0xa5
            //   0f84db000000         | je                  0xe1
            //   83f85b               | cmp                 eax, 0x5b
            //   0f84cb000000         | je                  0xd1

        $sequence_3 = { 8b07 83f808 750a be???????? e9???????? }
            // n = 5, score = 200
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   83f808               | cmp                 eax, 8
            //   750a                 | jne                 0xc
            //   be????????           |                     
            //   e9????????           |                     

        $sequence_4 = { e9???????? 83f80d 750a be???????? e9???????? 83f814 }
            // n = 6, score = 200
            //   e9????????           |                     
            //   83f80d               | cmp                 eax, 0xd
            //   750a                 | jne                 0xc
            //   be????????           |                     
            //   e9????????           |                     
            //   83f814               | cmp                 eax, 0x14

        $sequence_5 = { 750a be???????? e9???????? 83f828 750a be???????? }
            // n = 6, score = 200
            //   750a                 | jne                 0xc
            //   be????????           |                     
            //   e9????????           |                     
            //   83f828               | cmp                 eax, 0x28
            //   750a                 | jne                 0xc
            //   be????????           |                     

        $sequence_6 = { 0f848e000000 56 57 b980000000 8db5fcfdffff bf???????? }
            // n = 6, score = 200
            //   0f848e000000         | je                  0x94
            //   56                   | push                esi
            //   57                   | push                edi
            //   b980000000           | mov                 ecx, 0x80
            //   8db5fcfdffff         | lea                 esi, [ebp - 0x204]
            //   bf????????           |                     

        $sequence_7 = { 57 0fb7d6 6a02 52 ff15???????? }
            // n = 5, score = 200
            //   57                   | push                edi
            //   0fb7d6               | movzx               edx, si
            //   6a02                 | push                2
            //   52                   | push                edx
            //   ff15????????         |                     

        $sequence_8 = { be???????? e9???????? 83f809 750a be???????? e9???????? 83f80a }
            // n = 7, score = 200
            //   be????????           |                     
            //   e9????????           |                     
            //   83f809               | cmp                 eax, 9
            //   750a                 | jne                 0xc
            //   be????????           |                     
            //   e9????????           |                     
            //   83f80a               | cmp                 eax, 0xa

        $sequence_9 = { 83f828 750a be???????? e9???????? 83f82c 750a be???????? }
            // n = 7, score = 200
            //   83f828               | cmp                 eax, 0x28
            //   750a                 | jne                 0xc
            //   be????????           |                     
            //   e9????????           |                     
            //   83f82c               | cmp                 eax, 0x2c
            //   750a                 | jne                 0xc
            //   be????????           |                     

    condition:
        7 of them and filesize < 196608
}