rule win_wormhole_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.wormhole."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wormhole"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 e8???????? 83c408 8d542410 6aff 6a01 52 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8d542410             | lea                 edx, [esp + 0x10]
            //   6aff                 | push                -1
            //   6a01                 | push                1
            //   52                   | push                edx

        $sequence_1 = { 0f85c1000000 8b15???????? 8d4c2408 51 52 }
            // n = 5, score = 200
            //   0f85c1000000         | jne                 0xc7
            //   8b15????????         |                     
            //   8d4c2408             | lea                 ecx, [esp + 8]
            //   51                   | push                ecx
            //   52                   | push                edx

        $sequence_2 = { 6a00 6a00 ffd3 8b1d???????? 6aff 8d4c2414 6a00 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ffd3                 | call                ebx
            //   8b1d????????         |                     
            //   6aff                 | push                -1
            //   8d4c2414             | lea                 ecx, [esp + 0x14]
            //   6a00                 | push                0

        $sequence_3 = { a1???????? 85c0 7531 8b35???????? e8???????? 85c0 7519 }
            // n = 7, score = 200
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   7531                 | jne                 0x33
            //   8b35????????         |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7519                 | jne                 0x1b

        $sequence_4 = { 897c2438 8974243c ffd3 6a00 6a00 89442418 }
            // n = 6, score = 200
            //   897c2438             | mov                 dword ptr [esp + 0x38], edi
            //   8974243c             | mov                 dword ptr [esp + 0x3c], esi
            //   ffd3                 | call                ebx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   89442418             | mov                 dword ptr [esp + 0x18], eax

        $sequence_5 = { 6a00 6a00 ff15???????? 85c0 a3???????? 7404 }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   a3????????           |                     
            //   7404                 | je                  6

        $sequence_6 = { 6a00 52 68???????? 6a00 6a00 89742430 }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   52                   | push                edx
            //   68????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   89742430             | mov                 dword ptr [esp + 0x30], esi

        $sequence_7 = { 6685c0 743f a1???????? 85c0 7531 }
            // n = 5, score = 200
            //   6685c0               | test                ax, ax
            //   743f                 | je                  0x41
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   7531                 | jne                 0x33

        $sequence_8 = { 68c8000000 6a00 56 e8???????? 83c410 83f8ff }
            // n = 6, score = 200
            //   68c8000000           | push                0xc8
            //   6a00                 | push                0
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   83f8ff               | cmp                 eax, -1

        $sequence_9 = { 6a01 52 6a02 ffd3 8b35???????? }
            // n = 5, score = 200
            //   6a01                 | push                1
            //   52                   | push                edx
            //   6a02                 | push                2
            //   ffd3                 | call                ebx
            //   8b35????????         |                     

    condition:
        7 of them and filesize < 99576
}