rule win_wpbrutebot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.wpbrutebot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wpbrutebot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c745f85968337b 33c0 c645fc00 8d4809 304c05f8 40 83f804 }
            // n = 7, score = 100
            //   c745f85968337b       | mov                 dword ptr [ebp - 8], 0x7b336859
            //   33c0                 | xor                 eax, eax
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0
            //   8d4809               | lea                 ecx, [eax + 9]
            //   304c05f8             | xor                 byte ptr [ebp + eax - 8], cl
            //   40                   | inc                 eax
            //   83f804               | cmp                 eax, 4

        $sequence_1 = { 85c0 0f8438020000 ff7624 8b442418 ff742414 50 50 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   0f8438020000         | je                  0x23e
            //   ff7624               | push                dword ptr [esi + 0x24]
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   50                   | push                eax
            //   50                   | push                eax

        $sequence_2 = { f7e9 c1fa02 8bc2 c1e81f 03c2 83f803 764f }
            // n = 7, score = 100
            //   f7e9                 | imul                ecx
            //   c1fa02               | sar                 edx, 2
            //   8bc2                 | mov                 eax, edx
            //   c1e81f               | shr                 eax, 0x1f
            //   03c2                 | add                 eax, edx
            //   83f803               | cmp                 eax, 3
            //   764f                 | jbe                 0x51

        $sequence_3 = { c1c010 85c3 7416 8b449438 8904ef b810000000 668944ef04 }
            // n = 7, score = 100
            //   c1c010               | rol                 eax, 0x10
            //   85c3                 | test                ebx, eax
            //   7416                 | je                  0x18
            //   8b449438             | mov                 eax, dword ptr [esp + edx*4 + 0x38]
            //   8904ef               | mov                 dword ptr [edi + ebp*8], eax
            //   b810000000           | mov                 eax, 0x10
            //   668944ef04           | mov                 word ptr [edi + ebp*8 + 4], ax

        $sequence_4 = { ff742458 0f45c8 8d44247c ff742434 55 56 52 }
            // n = 7, score = 100
            //   ff742458             | push                dword ptr [esp + 0x58]
            //   0f45c8               | cmovne              ecx, eax
            //   8d44247c             | lea                 eax, [esp + 0x7c]
            //   ff742434             | push                dword ptr [esp + 0x34]
            //   55                   | push                ebp
            //   56                   | push                esi
            //   52                   | push                edx

        $sequence_5 = { c3 b8???????? eb0c b8???????? eb05 b8???????? 57 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   b8????????           |                     
            //   eb0c                 | jmp                 0xe
            //   b8????????           |                     
            //   eb05                 | jmp                 7
            //   b8????????           |                     
            //   57                   | push                edi

        $sequence_6 = { c74008???????? c7400ca0f76200 c74010e1000000 c3 e8???????? 85c0 0f8488000000 }
            // n = 7, score = 100
            //   c74008????????       |                     
            //   c7400ca0f76200       | mov                 dword ptr [eax + 0xc], 0x62f7a0
            //   c74010e1000000       | mov                 dword ptr [eax + 0x10], 0xe1
            //   c3                   | ret                 
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8488000000         | je                  0x8e

        $sequence_7 = { eb10 83f804 755e 807c244020 0f85130d0000 8b442418 8d0480 }
            // n = 7, score = 100
            //   eb10                 | jmp                 0x12
            //   83f804               | cmp                 eax, 4
            //   755e                 | jne                 0x60
            //   807c244020           | cmp                 byte ptr [esp + 0x40], 0x20
            //   0f85130d0000         | jne                 0xd19
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   8d0480               | lea                 eax, [eax + eax*4]

        $sequence_8 = { c605????????00 e8???????? b9???????? c645fc05 e8???????? 6a6b 68???????? }
            // n = 7, score = 100
            //   c605????????00       |                     
            //   e8????????           |                     
            //   b9????????           |                     
            //   c645fc05             | mov                 byte ptr [ebp - 4], 5
            //   e8????????           |                     
            //   6a6b                 | push                0x6b
            //   68????????           |                     

        $sequence_9 = { 803f2f 0f8518020000 807f012f 7563 8a4702 83c702 3c2f }
            // n = 7, score = 100
            //   803f2f               | cmp                 byte ptr [edi], 0x2f
            //   0f8518020000         | jne                 0x21e
            //   807f012f             | cmp                 byte ptr [edi + 1], 0x2f
            //   7563                 | jne                 0x65
            //   8a4702               | mov                 al, byte ptr [edi + 2]
            //   83c702               | add                 edi, 2
            //   3c2f                 | cmp                 al, 0x2f

    condition:
        7 of them and filesize < 5134336
}