rule win_wslink_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.wslink."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.wslink"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bd0 e8???????? 4885c0 7494 48638ba0000000 488bd1 3b8ba4000000 }
            // n = 7, score = 100
            //   8bd0                 | mov                 edx, ebp
            //   e8????????           |                     
            //   4885c0               | inc                 esp
            //   7494                 | mov                 edx, ebp
            //   48638ba0000000       | dec                 esp
            //   488bd1               | lea                 ebp, [0xfffbabe3]
            //   3b8ba4000000         | nop                 dword ptr [eax]

        $sequence_1 = { 488b8be8000000 4885c9 7405 e8???????? 488b7b08 4885ff }
            // n = 6, score = 100
            //   488b8be8000000       | mov                 edi, eax
            //   4885c9               | dec                 eax
            //   7405                 | test                eax, eax
            //   e8????????           |                     
            //   488b7b08             | jne                 0x331
            //   4885ff               | cmp                 dword ptr [esp + 0x50], -1

        $sequence_2 = { 488b05???????? 4833c4 48898424c0000000 33db 458be1 4c89442450 4183cfff }
            // n = 7, score = 100
            //   488b05????????       |                     
            //   4833c4               | dec                 eax
            //   48898424c0000000     | add                 esp, 0x20
            //   33db                 | je                  0x2f1
            //   458be1               | dec                 eax
            //   4c89442450           | lea                 edx, [0x115eb]
            //   4183cfff             | dec                 eax

        $sequence_3 = { 4c8d0d633b0a00 448d400d e9???????? 83781000 0f859f000000 83780800 0f8495000000 }
            // n = 7, score = 100
            //   4c8d0d633b0a00       | dec                 eax
            //   448d400d             | mov                 eax, dword ptr [ecx + 8]
            //   e9????????           |                     
            //   83781000             | dec                 eax
            //   0f859f000000         | mov                 dword ptr [esp + 0x30], eax
            //   83780800             | inc                 esp
            //   0f8495000000         | mov                 eax, dword ptr [ecx]

        $sequence_4 = { 418bc5 e9???????? bad9000000 4c8d0d96920700 b910000000 448d42b3 c7442420d8000000 }
            // n = 7, score = 100
            //   418bc5               | dec                 eax
            //   e9????????           |                     
            //   bad9000000           | xor                 edx, dword ptr [esp + 0x70]
            //   4c8d0d96920700       | dec                 ecx
            //   b910000000           | xor                 dword ptr [esp + eax - 8], edx
            //   448d42b3             | dec                 ecx
            //   c7442420d8000000     | mov                 eax, dword ptr [esi]

        $sequence_5 = { 4885c0 743d 4885f6 740e 660f1f440000 48ffce 881c06 }
            // n = 7, score = 100
            //   4885c0               | dec                 esp
            //   743d                 | lea                 ecx, [0x66ecd]
            //   4885f6               | mov                 dword ptr [esp + 0x20], 0xbe
            //   740e                 | lea                 ecx, [edx - 0x39]
            //   660f1f440000         | inc                 esp
            //   48ffce               | lea                 eax, [edx - 0x61]
            //   881c06               | jmp                 0xfd8

        $sequence_6 = { 7532 4c8d0d97450a00 8d4810 448d4008 ba9a000000 c744242048010000 e8???????? }
            // n = 7, score = 100
            //   7532                 | inc                 ecx
            //   4c8d0d97450a00       | mov                 eax, 0x6e
            //   8d4810               | mov                 edi, eax
            //   448d4008             | test                eax, eax
            //   ba9a000000           | jg                  0x2cc
            //   c744242048010000     | mov                 dword ptr [esp + 0x20], 0x9e
            //   e8????????           |                     

        $sequence_7 = { 488bd8 4885c0 752b 4c8d0d885f0b00 8d506c 8d4820 448d4041 }
            // n = 7, score = 100
            //   488bd8               | inc                 ecx
            //   4885c0               | mov                 esi, 4
            //   752b                 | jmp                 0x1de
            //   4c8d0d885f0b00       | cmp                 esi, 0x17
            //   8d506c               | inc                 ebp
            //   8d4820               | mov                 esi, edi
            //   448d4041             | mov                 eax, 3

        $sequence_8 = { 0302 6690 e11c 0100 ec 1c01 00d6 }
            // n = 7, score = 100
            //   0302                 | dec                 ecx
            //   6690                 | mov                 ecx, esi
            //   e11c                 | dec                 eax
            //   0100                 | mov                 esi, ebx
            //   ec                   | mov                 ecx, 1
            //   1c01                 | test                eax, eax
            //   00d6                 | dec                 eax

        $sequence_9 = { e8???????? 8b8c2490000000 4885c0 746e 894b08 4d8b0f 498b5500 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8b8c2490000000       | inc                 esp
            //   4885c0               | lea                 eax, [eax + 0x42]
            //   746e                 | dec                 eax
            //   894b08               | lea                 edx, [0x7f4de]
            //   4d8b0f               | mov                 ecx, 0x128
            //   498b5500             | dec                 eax

    condition:
        7 of them and filesize < 2007040
}