rule win_xbtl_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xbtl."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xbtl"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945f8 03c0 03c0 50 52 8945fc e8???????? }
            // n = 7, score = 100
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   03c0                 | add                 eax, eax
            //   03c0                 | add                 eax, eax
            //   50                   | push                eax
            //   52                   | push                edx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   e8????????           |                     

        $sequence_1 = { 8a08 40 84c9 75f9 2bc6 8dbc05f4fdffff 89bde0fcffff }
            // n = 7, score = 100
            //   8a08                 | mov                 cl, byte ptr [eax]
            //   40                   | inc                 eax
            //   84c9                 | test                cl, cl
            //   75f9                 | jne                 0xfffffffb
            //   2bc6                 | sub                 eax, esi
            //   8dbc05f4fdffff       | lea                 edi, [ebp + eax - 0x20c]
            //   89bde0fcffff         | mov                 dword ptr [ebp - 0x320], edi

        $sequence_2 = { ff15???????? 8b07 8b4820 51 68???????? 8d542428 6a40 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   8b4820               | mov                 ecx, dword ptr [eax + 0x20]
            //   51                   | push                ecx
            //   68????????           |                     
            //   8d542428             | lea                 edx, [esp + 0x28]
            //   6a40                 | push                0x40

        $sequence_3 = { 8b55e0 8b470c 8b4490f8 8945e0 85c0 742f 0fbf4304 }
            // n = 7, score = 100
            //   8b55e0               | mov                 edx, dword ptr [ebp - 0x20]
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   8b4490f8             | mov                 eax, dword ptr [eax + edx*4 - 8]
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   85c0                 | test                eax, eax
            //   742f                 | je                  0x31
            //   0fbf4304             | movsx               eax, word ptr [ebx + 4]

        $sequence_4 = { 81e200ff0000 33ca 8bd7 c1ea18 }
            // n = 4, score = 100
            //   81e200ff0000         | and                 edx, 0xff00
            //   33ca                 | xor                 ecx, edx
            //   8bd7                 | mov                 edx, edi
            //   c1ea18               | shr                 edx, 0x18

        $sequence_5 = { 40 8945fc 3b4608 0f8c78ffffff eb09 8b55fc 8b7508 }
            // n = 7, score = 100
            //   40                   | inc                 eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   3b4608               | cmp                 eax, dword ptr [esi + 8]
            //   0f8c78ffffff         | jl                  0xffffff7e
            //   eb09                 | jmp                 0xb
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]

        $sequence_6 = { 897004 8b5108 8bf2 c1ce08 81e600ff00ff }
            // n = 5, score = 100
            //   897004               | mov                 dword ptr [eax + 4], esi
            //   8b5108               | mov                 edx, dword ptr [ecx + 8]
            //   8bf2                 | mov                 esi, edx
            //   c1ce08               | ror                 esi, 8
            //   81e600ff00ff         | and                 esi, 0xff00ff00

        $sequence_7 = { 8b8d8cfdffff 8b9598fdffff 50 8b8588fdffff 50 8b8590fdffff 57 }
            // n = 7, score = 100
            //   8b8d8cfdffff         | mov                 ecx, dword ptr [ebp - 0x274]
            //   8b9598fdffff         | mov                 edx, dword ptr [ebp - 0x268]
            //   50                   | push                eax
            //   8b8588fdffff         | mov                 eax, dword ptr [ebp - 0x278]
            //   50                   | push                eax
            //   8b8590fdffff         | mov                 eax, dword ptr [ebp - 0x270]
            //   57                   | push                edi

        $sequence_8 = { 8b07 68a00f0000 8d4c2448 51 89742448 }
            // n = 5, score = 100
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   68a00f0000           | push                0xfa0
            //   8d4c2448             | lea                 ecx, [esp + 0x48]
            //   51                   | push                ecx
            //   89742448             | mov                 dword ptr [esp + 0x48], esi

        $sequence_9 = { 8b530c 0fbfc8 837c8afc00 74e5 8b4308 3daa55ff7f }
            // n = 6, score = 100
            //   8b530c               | mov                 edx, dword ptr [ebx + 0xc]
            //   0fbfc8               | movsx               ecx, ax
            //   837c8afc00           | cmp                 dword ptr [edx + ecx*4 - 4], 0
            //   74e5                 | je                  0xffffffe7
            //   8b4308               | mov                 eax, dword ptr [ebx + 8]
            //   3daa55ff7f           | cmp                 eax, 0x7fff55aa

    condition:
        7 of them and filesize < 401408
}