rule win_xdspy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xdspy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xdspy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d85b0510000 50 e8???????? 8d85b0510000 50 897da4 }
            // n = 6, score = 200
            //   8d85b0510000         | lea                 eax, [ebp + 0x51b0]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d85b0510000         | lea                 eax, [ebp + 0x51b0]
            //   50                   | push                eax
            //   897da4               | mov                 dword ptr [ebp - 0x5c], edi

        $sequence_1 = { 5e e8???????? c9 c3 53 56 68???????? }
            // n = 7, score = 200
            //   5e                   | pop                 esi
            //   e8????????           |                     
            //   c9                   | leave               
            //   c3                   | ret                 
            //   53                   | push                ebx
            //   56                   | push                esi
            //   68????????           |                     

        $sequence_2 = { e8???????? 8d851cd1ffff 50 e8???????? ff35???????? 8d851cd1ffff 50 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8d851cd1ffff         | lea                 eax, [ebp - 0x2ee4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   ff35????????         |                     
            //   8d851cd1ffff         | lea                 eax, [ebp - 0x2ee4]
            //   50                   | push                eax

        $sequence_3 = { 89459c ff15???????? 85c0 7413 ff15???????? 3db7000000 7506 }
            // n = 7, score = 200
            //   89459c               | mov                 dword ptr [ebp - 0x64], eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7413                 | je                  0x15
            //   ff15????????         |                     
            //   3db7000000           | cmp                 eax, 0xb7
            //   7506                 | jne                 8

        $sequence_4 = { 56 8bf8 e8???????? 83c410 8bd8 85ff }
            // n = 6, score = 200
            //   56                   | push                esi
            //   8bf8                 | mov                 edi, eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8bd8                 | mov                 ebx, eax
            //   85ff                 | test                edi, edi

        $sequence_5 = { 85f6 0f84ba000000 8975e0 8b04bd804e4100 0500080000 3bf0 }
            // n = 6, score = 200
            //   85f6                 | test                esi, esi
            //   0f84ba000000         | je                  0xc0
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   8b04bd804e4100       | mov                 eax, dword ptr [edi*4 + 0x414e80]
            //   0500080000           | add                 eax, 0x800
            //   3bf0                 | cmp                 esi, eax

        $sequence_6 = { c3 8bff 56 57 33ff 8db730074100 }
            // n = 6, score = 200
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   56                   | push                esi
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   8db730074100         | lea                 esi, [edi + 0x410730]

        $sequence_7 = { e8???????? 68ff000000 e8???????? 59 59 8b7508 8d34f548044100 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   68ff000000           | push                0xff
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8d34f548044100       | lea                 esi, [esi*8 + 0x410448]

        $sequence_8 = { 0f8514010000 83fb01 0f850b010000 e8???????? 488d8dc0130000 ff15???????? }
            // n = 6, score = 100
            //   0f8514010000         | jne                 0x11a
            //   83fb01               | cmp                 ebx, 1
            //   0f850b010000         | jne                 0x111
            //   e8????????           |                     
            //   488d8dc0130000       | dec                 eax
            //   ff15????????         |                     

        $sequence_9 = { 88840d80070000 488d4901 84c0 75e8 80bd8007000000 488d8580070000 }
            // n = 6, score = 100
            //   88840d80070000       | dec                 eax
            //   488d4901             | mov                 ecx, ebx
            //   84c0                 | nop                 dword ptr [eax + eax]
            //   75e8                 | inc                 edx
            //   80bd8007000000       | movzx               eax, byte ptr [ecx + edi + 0x17949c]
            //   488d8580070000       | dec                 ecx

        $sequence_10 = { 48898424c0000000 4889bc24c8000000 488d8c2480000000 ff15???????? }
            // n = 4, score = 100
            //   48898424c0000000     | dec                 eax
            //   4889bc24c8000000     | cmp                 ebx, 0xe
            //   488d8c2480000000     | jl                  0xffffffec
            //   ff15????????         |                     

        $sequence_11 = { 4983e801 75ea b801000000 8d501f 6690 }
            // n = 5, score = 100
            //   4983e801             | lea                 edx, [0x13a85]
            //   75ea                 | dec                 eax
            //   b801000000           | mov                 ecx, ebx
            //   8d501f               | and                 ecx, 0x3f
            //   6690                 | jne                 0xffffffea

        $sequence_12 = { 880413 48ffc3 4883fb0e 7cea }
            // n = 4, score = 100
            //   880413               | lea                 ecx, [ebp + 0x13c0]
            //   48ffc3               | mov                 byte ptr [ebx + edx], al
            //   4883fb0e             | dec                 eax
            //   7cea                 | inc                 ebx

        $sequence_13 = { 75e8 488bcb 0f1f440000 420fb684399c941700 }
            // n = 4, score = 100
            //   75e8                 | mov                 dword ptr [esp + 0xc8], edi
            //   488bcb               | dec                 eax
            //   0f1f440000           | lea                 ecx, [esp + 0x80]
            //   420fb684399c941700     | dec    eax

        $sequence_14 = { 7413 0f1f840000000000 fe08 488d4001 403838 75f5 }
            // n = 6, score = 100
            //   7413                 | sub                 eax, 1
            //   0f1f840000000000     | jne                 0xffffffec
            //   fe08                 | mov                 eax, 1
            //   488d4001             | lea                 edx, [eax + 0x1f]
            //   403838               | nop                 
            //   75f5                 | mov                 byte ptr [ebp + ecx + 0x780], al

        $sequence_15 = { e8???????? 488b05???????? 488d15853a0100 488bcb 83e13f }
            // n = 5, score = 100
            //   e8????????           |                     
            //   488b05????????       |                     
            //   488d15853a0100       | dec                 eax
            //   488bcb               | mov                 dword ptr [esp + 0xc0], eax
            //   83e13f               | dec                 eax

    condition:
        7 of them and filesize < 3244032
}