rule win_xfscashncr_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xfscashncr."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xfscashncr"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 741b 0fbe4d82 85c9 7413 8b4d10 e8???????? 0fbe10 }
            // n = 7, score = 100
            //   741b                 | je                  0x1d
            //   0fbe4d82             | movsx               ecx, byte ptr [ebp - 0x7e]
            //   85c9                 | test                ecx, ecx
            //   7413                 | je                  0x15
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   e8????????           |                     
            //   0fbe10               | movsx               edx, byte ptr [eax]

        $sequence_1 = { 8b4d18 e8???????? 8b8564ffffff 50 0fb64d1c 51 8b5514 }
            // n = 7, score = 100
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   e8????????           |                     
            //   8b8564ffffff         | mov                 eax, dword ptr [ebp - 0x9c]
            //   50                   | push                eax
            //   0fb64d1c             | movzx               ecx, byte ptr [ebp + 0x1c]
            //   51                   | push                ecx
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]

        $sequence_2 = { c1f805 8b4de0 83e11f c1e106 030c85c0195700 894de4 8b55e4 }
            // n = 7, score = 100
            //   c1f805               | sar                 eax, 5
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   83e11f               | and                 ecx, 0x1f
            //   c1e106               | shl                 ecx, 6
            //   030c85c0195700       | add                 ecx, dword ptr [eax*4 + 0x5719c0]
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]

        $sequence_3 = { 8d450c 50 e8???????? 83c408 0fb6c8 85c9 742a }
            // n = 7, score = 100
            //   8d450c               | lea                 eax, [ebp + 0xc]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   0fb6c8               | movzx               ecx, al
            //   85c9                 | test                ecx, ecx
            //   742a                 | je                  0x2c

        $sequence_4 = { 004fed 4e 0015???????? ed 4e 0000 0501050205 }
            // n = 7, score = 100
            //   004fed               | add                 byte ptr [edi - 0x13], cl
            //   4e                   | dec                 esi
            //   0015????????         |                     
            //   ed                   | in                  eax, dx
            //   4e                   | dec                 esi
            //   0000                 | add                 byte ptr [eax], al
            //   0501050205           | add                 eax, 0x5020501

        $sequence_5 = { 8955f4 8b450c 8b4d18 8d14c1 8955f8 8b4508 50 }
            // n = 7, score = 100
            //   8955f4               | mov                 dword ptr [ebp - 0xc], edx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   8d14c1               | lea                 edx, [ecx + eax*8]
            //   8955f8               | mov                 dword ptr [ebp - 8], edx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   50                   | push                eax

        $sequence_6 = { 8b45d0 8b0c85c0195700 81c100080000 394de4 7366 8b55e4 c6420400 }
            // n = 7, score = 100
            //   8b45d0               | mov                 eax, dword ptr [ebp - 0x30]
            //   8b0c85c0195700       | mov                 ecx, dword ptr [eax*4 + 0x5719c0]
            //   81c100080000         | add                 ecx, 0x800
            //   394de4               | cmp                 dword ptr [ebp - 0x1c], ecx
            //   7366                 | jae                 0x68
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   c6420400             | mov                 byte ptr [edx + 4], 0

        $sequence_7 = { d1f8 b902000000 c1e100 8b5508 0fb70c0a c1e10f 0bc1 }
            // n = 7, score = 100
            //   d1f8                 | sar                 eax, 1
            //   b902000000           | mov                 ecx, 2
            //   c1e100               | shl                 ecx, 0
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   0fb70c0a             | movzx               ecx, word ptr [edx + ecx]
            //   c1e10f               | shl                 ecx, 0xf
            //   0bc1                 | or                  eax, ecx

        $sequence_8 = { 8b55fc 0fb7040a 85c0 752f b902000000 c1e100 8b55fc }
            // n = 7, score = 100
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   0fb7040a             | movzx               eax, word ptr [edx + ecx]
            //   85c0                 | test                eax, eax
            //   752f                 | jne                 0x31
            //   b902000000           | mov                 ecx, 2
            //   c1e100               | shl                 ecx, 0
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_9 = { 0fb755a4 52 6a01 8b4524 50 8d4dd4 e8???????? }
            // n = 7, score = 100
            //   0fb755a4             | movzx               edx, word ptr [ebp - 0x5c]
            //   52                   | push                edx
            //   6a01                 | push                1
            //   8b4524               | mov                 eax, dword ptr [ebp + 0x24]
            //   50                   | push                eax
            //   8d4dd4               | lea                 ecx, [ebp - 0x2c]
            //   e8????????           |                     

    condition:
        7 of them and filesize < 3126272
}