rule win_xiangoop_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xiangoop."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xiangoop"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8945fc e9???????? e9???????? 837d1020 0f850e040000 b901000000 6bd100 }
            // n = 7, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   e9????????           |                     
            //   e9????????           |                     
            //   837d1020             | cmp                 dword ptr [ebp + 0x10], 0x20
            //   0f850e040000         | jne                 0x414
            //   b901000000           | mov                 ecx, 1
            //   6bd100               | imul                edx, ecx, 0

        $sequence_1 = { 81e2ff000000 8b45f4 c1e810 25ff000000 8b0c95587d0110 330c8558650110 8b55f8 }
            // n = 7, score = 100
            //   81e2ff000000         | and                 edx, 0xff
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   c1e810               | shr                 eax, 0x10
            //   25ff000000           | and                 eax, 0xff
            //   8b0c95587d0110       | mov                 ecx, dword ptr [edx*4 + 0x10017d58]
            //   330c8558650110       | xor                 ecx, dword ptr [eax*4 + 0x10016558]
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]

        $sequence_2 = { 6bd10d 8b4dfc 890411 ba04000000 6bc206 }
            // n = 5, score = 100
            //   6bd10d               | imul                edx, ecx, 0xd
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   890411               | mov                 dword ptr [ecx + edx], eax
            //   ba04000000           | mov                 edx, 4
            //   6bc206               | imul                eax, edx, 6

        $sequence_3 = { 83e801 0f8539010000 c745e414430110 8b4508 }
            // n = 4, score = 100
            //   83e801               | sub                 eax, 1
            //   0f8539010000         | jne                 0x13f
            //   c745e414430110       | mov                 dword ptr [ebp - 0x1c], 0x10014314
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_4 = { 8b45f4 0fb64c081c 81e1ff000000 c1e108 0bd1 }
            // n = 5, score = 100
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   0fb64c081c           | movzx               ecx, byte ptr [eax + ecx + 0x1c]
            //   81e1ff000000         | and                 ecx, 0xff
            //   c1e108               | shl                 ecx, 8
            //   0bd1                 | or                  edx, ecx

        $sequence_5 = { 57 8d1c8518b00110 8b03 90 8b15???????? 83cfff 8bca }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8d1c8518b00110       | lea                 ebx, [eax*4 + 0x1001b018]
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   90                   | nop                 
            //   8b15????????         |                     
            //   83cfff               | or                  edi, 0xffffffff
            //   8bca                 | mov                 ecx, edx

        $sequence_6 = { b804000000 6bc805 8b45fc 8b75fc 8b1410 }
            // n = 5, score = 100
            //   b804000000           | mov                 eax, 4
            //   6bc805               | imul                ecx, eax, 5
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   8b1410               | mov                 edx, dword ptr [eax + edx]

        $sequence_7 = { 8b55f0 c1ea00 81e2ff000000 330495585d0110 b904000000 6bd105 }
            // n = 6, score = 100
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   c1ea00               | shr                 edx, 0
            //   81e2ff000000         | and                 edx, 0xff
            //   330495585d0110       | xor                 eax, dword ptr [edx*4 + 0x10015d58]
            //   b904000000           | mov                 ecx, 4
            //   6bd105               | imul                edx, ecx, 5

        $sequence_8 = { 8b45dc c1e800 25ff000000 330c85585d0110 ba04000000 6bc203 8b55fc }
            // n = 7, score = 100
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   c1e800               | shr                 eax, 0
            //   25ff000000           | and                 eax, 0xff
            //   330c85585d0110       | xor                 ecx, dword ptr [eax*4 + 0x10015d58]
            //   ba04000000           | mov                 edx, 4
            //   6bc203               | imul                eax, edx, 3
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]

        $sequence_9 = { b901000000 6bd100 8b45f4 0fb64c1010 }
            // n = 4, score = 100
            //   b901000000           | mov                 ecx, 1
            //   6bd100               | imul                edx, ecx, 0
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   0fb64c1010           | movzx               ecx, byte ptr [eax + edx + 0x10]

    condition:
        7 of them and filesize < 246784
}