rule win_xorist_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xorist."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xorist"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a38 5b 8b7720 8b6f20 83e63f 8b4724 0fa4e803 }
            // n = 7, score = 100
            //   6a38                 | push                0x38
            //   5b                   | pop                 ebx
            //   8b7720               | mov                 esi, dword ptr [edi + 0x20]
            //   8b6f20               | mov                 ebp, dword ptr [edi + 0x20]
            //   83e63f               | and                 esi, 0x3f
            //   8b4724               | mov                 eax, dword ptr [edi + 0x24]
            //   0fa4e803             | shld                eax, ebp, 3

        $sequence_1 = { 894604 ff7708 e8???????? 894608 ff770c e8???????? 89460c }
            // n = 7, score = 100
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   ff7708               | push                dword ptr [edi + 8]
            //   e8????????           |                     
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   ff770c               | push                dword ptr [edi + 0xc]
            //   e8????????           |                     
            //   89460c               | mov                 dword ptr [esi + 0xc], eax

        $sequence_2 = { 8d85c4eeffff 50 53 e8???????? 33c0 3845f2 7515 }
            // n = 7, score = 100
            //   8d85c4eeffff         | lea                 eax, [ebp - 0x113c]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   3845f2               | cmp                 byte ptr [ebp - 0xe], al
            //   7515                 | jne                 0x17

        $sequence_3 = { 8d8d389fffff e9???????? 57 8d8580bfffff 50 8d85ecefffff 50 }
            // n = 7, score = 100
            //   8d8d389fffff         | lea                 ecx, [ebp - 0x60c8]
            //   e9????????           |                     
            //   57                   | push                edi
            //   8d8580bfffff         | lea                 eax, [ebp - 0x4080]
            //   50                   | push                eax
            //   8d85ecefffff         | lea                 eax, [ebp - 0x1014]
            //   50                   | push                eax

        $sequence_4 = { 753c 85f6 740d 3883cd000000 7430 f6c10f 742b }
            // n = 7, score = 100
            //   753c                 | jne                 0x3e
            //   85f6                 | test                esi, esi
            //   740d                 | je                  0xf
            //   3883cd000000         | cmp                 byte ptr [ebx + 0xcd], al
            //   7430                 | je                  0x32
            //   f6c10f               | test                cl, 0xf
            //   742b                 | je                  0x2d

        $sequence_5 = { 8d49fc 83ea01 75f3 8d6f04 895e60 8bcd e8???????? }
            // n = 7, score = 100
            //   8d49fc               | lea                 ecx, [ecx - 4]
            //   83ea01               | sub                 edx, 1
            //   75f3                 | jne                 0xfffffff5
            //   8d6f04               | lea                 ebp, [edi + 4]
            //   895e60               | mov                 dword ptr [esi + 0x60], ebx
            //   8bcd                 | mov                 ecx, ebp
            //   e8????????           |                     

        $sequence_6 = { 7539 ff742424 8bce e8???????? 8bce e8???????? 84c0 }
            // n = 7, score = 100
            //   7539                 | jne                 0x3b
            //   ff742424             | push                dword ptr [esp + 0x24]
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   84c0                 | test                al, al

        $sequence_7 = { 6a0f 5d 40 3bc5 731a 8d889f070000 }
            // n = 6, score = 100
            //   6a0f                 | push                0xf
            //   5d                   | pop                 ebp
            //   40                   | inc                 eax
            //   3bc5                 | cmp                 eax, ebp
            //   731a                 | jae                 0x1c
            //   8d889f070000         | lea                 ecx, [eax + 0x79f]

        $sequence_8 = { 6a00 6800ca9a3b ff742414 8bf1 ff742414 e8???????? }
            // n = 6, score = 100
            //   6a00                 | push                0
            //   6800ca9a3b           | push                0x3b9aca00
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   8bf1                 | mov                 esi, ecx
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   e8????????           |                     

        $sequence_9 = { 5d 5b 83c41c c3 8b86dc4b0000 8a4c2424 8808 }
            // n = 7, score = 100
            //   5d                   | pop                 ebp
            //   5b                   | pop                 ebx
            //   83c41c               | add                 esp, 0x1c
            //   c3                   | ret                 
            //   8b86dc4b0000         | mov                 eax, dword ptr [esi + 0x4bdc]
            //   8a4c2424             | mov                 cl, byte ptr [esp + 0x24]
            //   8808                 | mov                 byte ptr [eax], cl

    condition:
        7 of them and filesize < 1402880
}