rule win_xpan_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xpan."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xpan"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b16 899310010000 8b542414 e8???????? 89b310010000 e9???????? 8b6904 }
            // n = 7, score = 400
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   899310010000         | mov                 dword ptr [ebx + 0x110], edx
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]
            //   e8????????           |                     
            //   89b310010000         | mov                 dword ptr [ebx + 0x110], esi
            //   e9????????           |                     
            //   8b6904               | mov                 ebp, dword ptr [ecx + 4]

        $sequence_1 = { 8b4d10 85c9 0f84cdfdffff 66837d14ff bb01000000 0f84d7000000 8b4d08 }
            // n = 7, score = 400
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   85c9                 | test                ecx, ecx
            //   0f84cdfdffff         | je                  0xfffffdd3
            //   66837d14ff           | cmp                 word ptr [ebp + 0x14], -1
            //   bb01000000           | mov                 ebx, 1
            //   0f84d7000000         | je                  0xdd
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_2 = { 0fb64c2454 8b442440 896c2408 88542418 890424 894c2404 }
            // n = 6, score = 400
            //   0fb64c2454           | movzx               ecx, byte ptr [esp + 0x54]
            //   8b442440             | mov                 eax, dword ptr [esp + 0x40]
            //   896c2408             | mov                 dword ptr [esp + 8], ebp
            //   88542418             | mov                 byte ptr [esp + 0x18], dl
            //   890424               | mov                 dword ptr [esp], eax
            //   894c2404             | mov                 dword ptr [esp + 4], ecx

        $sequence_3 = { 8b4508 c685f0feffff00 890424 e8???????? 8d8d60ffffff 8985d4feffff e8???????? }
            // n = 7, score = 400
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c685f0feffff00       | mov                 byte ptr [ebp - 0x110], 0
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8d8d60ffffff         | lea                 ecx, [ebp - 0xa0]
            //   8985d4feffff         | mov                 dword ptr [ebp - 0x12c], eax
            //   e8????????           |                     

        $sequence_4 = { b904000000 89f5 e9???????? 8b8c24b0000000 8b5004 8b00 }
            // n = 6, score = 400
            //   b904000000           | mov                 ecx, 4
            //   89f5                 | mov                 ebp, esi
            //   e9????????           |                     
            //   8b8c24b0000000       | mov                 ecx, dword ptr [esp + 0xb0]
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   8b00                 | mov                 eax, dword ptr [eax]

        $sequence_5 = { 89eb 0f841dffffff f744245400040000 7483 0fb6442454 89742408 892c24 }
            // n = 7, score = 400
            //   89eb                 | mov                 ebx, ebp
            //   0f841dffffff         | je                  0xffffff23
            //   f744245400040000     | test                dword ptr [esp + 0x54], 0x400
            //   7483                 | je                  0xffffff85
            //   0fb6442454           | movzx               eax, byte ptr [esp + 0x54]
            //   89742408             | mov                 dword ptr [esp + 8], esi
            //   892c24               | mov                 dword ptr [esp], ebp

        $sequence_6 = { 8b4bf4 85c9 7438 807dc600 8d45e4 8945c8 }
            // n = 6, score = 400
            //   8b4bf4               | mov                 ecx, dword ptr [ebx - 0xc]
            //   85c9                 | test                ecx, ecx
            //   7438                 | je                  0x3a
            //   807dc600             | cmp                 byte ptr [ebp - 0x3a], 0
            //   8d45e4               | lea                 eax, [ebp - 0x1c]
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax

        $sequence_7 = { 89d3 75ed 8b4728 83f8ff 7475 39f0 0f4df0 }
            // n = 7, score = 400
            //   89d3                 | mov                 ebx, edx
            //   75ed                 | jne                 0xffffffef
            //   8b4728               | mov                 eax, dword ptr [edi + 0x28]
            //   83f8ff               | cmp                 eax, -1
            //   7475                 | je                  0x77
            //   39f0                 | cmp                 eax, esi
            //   0f4df0               | cmovge              esi, eax

        $sequence_8 = { 7412 85ff 0f846e010000 85c0 ba???????? 0f44c2 85f6 }
            // n = 7, score = 400
            //   7412                 | je                  0x14
            //   85ff                 | test                edi, edi
            //   0f846e010000         | je                  0x174
            //   85c0                 | test                eax, eax
            //   ba????????           |                     
            //   0f44c2               | cmove               eax, edx
            //   85f6                 | test                esi, esi

        $sequence_9 = { 85d2 89742418 8b6c2444 8b74241c 0f8571feffff c647ff00 b801000000 }
            // n = 7, score = 400
            //   85d2                 | test                edx, edx
            //   89742418             | mov                 dword ptr [esp + 0x18], esi
            //   8b6c2444             | mov                 ebp, dword ptr [esp + 0x44]
            //   8b74241c             | mov                 esi, dword ptr [esp + 0x1c]
            //   0f8571feffff         | jne                 0xfffffe77
            //   c647ff00             | mov                 byte ptr [edi - 1], 0
            //   b801000000           | mov                 eax, 1

    condition:
        7 of them and filesize < 3235840
}