rule win_xtinyloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xtinyloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xtinyloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff35???????? e8???????? 8b35???????? 83c448 8944241c 85db 7409 }
            // n = 7, score = 100
            //   ff35????????         |                     
            //   e8????????           |                     
            //   8b35????????         |                     
            //   83c448               | add                 esp, 0x48
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   85db                 | test                ebx, ebx
            //   7409                 | je                  0xb

        $sequence_1 = { 7437 57 ff15???????? 85c0 7425 56 }
            // n = 6, score = 100
            //   7437                 | je                  0x39
            //   57                   | push                edi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7425                 | je                  0x27
            //   56                   | push                esi

        $sequence_2 = { e8???????? 50 ff35???????? e8???????? a3???????? 0fb605???????? 83c444 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   50                   | push                eax
            //   ff35????????         |                     
            //   e8????????           |                     
            //   a3????????           |                     
            //   0fb605????????       |                     
            //   83c444               | add                 esp, 0x44

        $sequence_3 = { ff45fc 8b45fc 3b45f4 72be 33c0 5f 5e }
            // n = 7, score = 100
            //   ff45fc               | inc                 dword ptr [ebp - 4]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   3b45f4               | cmp                 eax, dword ptr [ebp - 0xc]
            //   72be                 | jb                  0xffffffc0
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_4 = { 8d45f8 50 8b450c 2bc7 }
            // n = 4, score = 100
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   2bc7                 | sub                 eax, edi

        $sequence_5 = { 85c0 7442 8b45fc 8b0c86 8b450c }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   7442                 | je                  0x44
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b0c86               | mov                 ecx, dword ptr [esi + eax*4]
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_6 = { 8b5d08 b84d5a0000 663903 7407 33c0 e9???????? }
            // n = 6, score = 100
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   b84d5a0000           | mov                 eax, 0x5a4d
            //   663903               | cmp                 word ptr [ebx], ax
            //   7407                 | je                  9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     

        $sequence_7 = { 57 ff15???????? 85c0 0f8450010000 8d45f8 }
            // n = 5, score = 100
            //   57                   | push                edi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8450010000         | je                  0x156
            //   8d45f8               | lea                 eax, [ebp - 8]

        $sequence_8 = { 57 895de4 895df4 895dec }
            // n = 4, score = 100
            //   57                   | push                edi
            //   895de4               | mov                 dword ptr [ebp - 0x1c], ebx
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx
            //   895dec               | mov                 dword ptr [ebp - 0x14], ebx

        $sequence_9 = { 7459 393d???????? 7451 393d???????? }
            // n = 4, score = 100
            //   7459                 | je                  0x5b
            //   393d????????         |                     
            //   7451                 | je                  0x53
            //   393d????????         |                     

    condition:
        7 of them and filesize < 50176
}