rule win_xtunnel_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xtunnel."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xtunnel"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bd0 c1fa08 8974241c 3bfa 0f852f050000 384601 }
            // n = 6, score = 1200
            //   8bd0                 | mov                 edx, eax
            //   c1fa08               | sar                 edx, 8
            //   8974241c             | mov                 dword ptr [esp + 0x1c], esi
            //   3bfa                 | cmp                 edi, edx
            //   0f852f050000         | jne                 0x535
            //   384601               | cmp                 byte ptr [esi + 1], al

        $sequence_1 = { 8d5306 83c606 3bd0 7436 681d080000 68???????? }
            // n = 6, score = 1200
            //   8d5306               | lea                 edx, [ebx + 6]
            //   83c606               | add                 esi, 6
            //   3bd0                 | cmp                 edx, eax
            //   7436                 | je                  0x38
            //   681d080000           | push                0x81d
            //   68????????           |                     

        $sequence_2 = { 90 8b8d30010000 8b5c2410 56 51 e8???????? }
            // n = 6, score = 1200
            //   90                   | nop                 
            //   8b8d30010000         | mov                 ecx, dword ptr [ebp + 0x130]
            //   8b5c2410             | mov                 ebx, dword ptr [esp + 0x10]
            //   56                   | push                esi
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_3 = { 8d9c2490000000 894110 83c410 8d4b01 8a03 43 }
            // n = 6, score = 1200
            //   8d9c2490000000       | lea                 ebx, [esp + 0x90]
            //   894110               | mov                 dword ptr [ecx + 0x10], eax
            //   83c410               | add                 esp, 0x10
            //   8d4b01               | lea                 ecx, [ebx + 1]
            //   8a03                 | mov                 al, byte ptr [ebx]
            //   43                   | inc                 ebx

        $sequence_4 = { eb67 8b7740 0fb60e 8b97c0000000 c1e118 898aec000000 }
            // n = 6, score = 1200
            //   eb67                 | jmp                 0x69
            //   8b7740               | mov                 esi, dword ptr [edi + 0x40]
            //   0fb60e               | movzx               ecx, byte ptr [esi]
            //   8b97c0000000         | mov                 edx, dword ptr [edi + 0xc0]
            //   c1e118               | shl                 ecx, 0x18
            //   898aec000000         | mov                 dword ptr [edx + 0xec], ecx

        $sequence_5 = { 8b11 83c202 52 e8???????? }
            // n = 4, score = 1200
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   83c202               | add                 edx, 2
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_6 = { e8???????? 99 b960000000 f7f9 }
            // n = 4, score = 1200
            //   e8????????           |                     
            //   99                   | cdq                 
            //   b960000000           | mov                 ecx, 0x60
            //   f7f9                 | idiv                ecx

        $sequence_7 = { 8d3c02 6887010000 c1ff03 68???????? }
            // n = 4, score = 1200
            //   8d3c02               | lea                 edi, [edx + eax]
            //   6887010000           | push                0x187
            //   c1ff03               | sar                 edi, 3
            //   68????????           |                     

        $sequence_8 = { 8d4c243c 51 57 ffd3 83c418 85c0 0f85d7010000 }
            // n = 7, score = 1200
            //   8d4c243c             | lea                 ecx, [esp + 0x3c]
            //   51                   | push                ecx
            //   57                   | push                edi
            //   ffd3                 | call                ebx
            //   83c418               | add                 esp, 0x18
            //   85c0                 | test                eax, eax
            //   0f85d7010000         | jne                 0x1dd

        $sequence_9 = { 8d440702 83c602 89442414 3bc3 0f879e000000 }
            // n = 5, score = 1200
            //   8d440702             | lea                 eax, [edi + eax + 2]
            //   83c602               | add                 esi, 2
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   3bc3                 | cmp                 eax, ebx
            //   0f879e000000         | ja                  0xa4

        $sequence_10 = { d1fa 83c404 03d2 52 51 50 }
            // n = 6, score = 1000
            //   d1fa                 | sar                 edx, 1
            //   83c404               | add                 esp, 4
            //   03d2                 | add                 edx, edx
            //   52                   | push                edx
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_11 = { 52 e8???????? 83c404 56 e8???????? 8b4310 }
            // n = 6, score = 1000
            //   52                   | push                edx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b4310               | mov                 eax, dword ptr [ebx + 0x10]

        $sequence_12 = { 1bc0 83e0fb 5f 5e 5b }
            // n = 5, score = 1000
            //   1bc0                 | sbb                 eax, eax
            //   83e0fb               | and                 eax, 0xfffffffb
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_13 = { e8???????? 8b5b04 53 e8???????? 8d5f20 83c404 895dec }
            // n = 7, score = 1000
            //   e8????????           |                     
            //   8b5b04               | mov                 ebx, dword ptr [ebx + 4]
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8d5f20               | lea                 ebx, [edi + 0x20]
            //   83c404               | add                 esp, 4
            //   895dec               | mov                 dword ptr [ebp - 0x14], ebx

        $sequence_14 = { 83c404 897dec 33db 895dfc 3bfb }
            // n = 5, score = 1000
            //   83c404               | add                 esp, 4
            //   897dec               | mov                 dword ptr [ebp - 0x14], edi
            //   33db                 | xor                 ebx, ebx
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   3bfb                 | cmp                 edi, ebx

        $sequence_15 = { 5d c20800 8b45f0 8b4df4 64890d00000000 }
            // n = 5, score = 1000
            //   5d                   | pop                 ebp
            //   c20800               | ret                 8
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   64890d00000000       | mov                 dword ptr fs:[0], ecx

        $sequence_16 = { 8b4624 894004 8b4624 894008 8b5624 c6421401 }
            // n = 6, score = 1000
            //   8b4624               | mov                 eax, dword ptr [esi + 0x24]
            //   894004               | mov                 dword ptr [eax + 4], eax
            //   8b4624               | mov                 eax, dword ptr [esi + 0x24]
            //   894008               | mov                 dword ptr [eax + 8], eax
            //   8b5624               | mov                 edx, dword ptr [esi + 0x24]
            //   c6421401             | mov                 byte ptr [edx + 0x14], 1

        $sequence_17 = { 8b4744 894004 8b4744 8900 }
            // n = 4, score = 1000
            //   8b4744               | mov                 eax, dword ptr [edi + 0x44]
            //   894004               | mov                 dword ptr [eax + 4], eax
            //   8b4744               | mov                 eax, dword ptr [edi + 0x44]
            //   8900                 | mov                 dword ptr [eax], eax

        $sequence_18 = { e8???????? 83c404 8945b0 8b45b4 50 6a00 }
            // n = 6, score = 500
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8945b0               | mov                 dword ptr [ebp - 0x50], eax
            //   8b45b4               | mov                 eax, dword ptr [ebp - 0x4c]
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_19 = { 83c404 8b4dfc 8b10 895104 8b45fc 5f }
            // n = 6, score = 300
            //   83c404               | add                 esp, 4
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   895104               | mov                 dword ptr [ecx + 4], edx
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   5f                   | pop                 edi

        $sequence_20 = { 83c404 8b4dfc 8a10 885104 8b45fc 5f }
            // n = 6, score = 300
            //   83c404               | add                 esp, 4
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   885104               | mov                 byte ptr [ecx + 4], dl
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   5f                   | pop                 edi

        $sequence_21 = { 83c404 8b55ac 668b00 668902 }
            // n = 4, score = 300
            //   83c404               | add                 esp, 4
            //   8b55ac               | mov                 edx, dword ptr [ebp - 0x54]
            //   668b00               | mov                 ax, word ptr [eax]
            //   668902               | mov                 word ptr [edx], ax

        $sequence_22 = { 83c404 8b4dfc 8b5104 8910 }
            // n = 4, score = 300
            //   83c404               | add                 esp, 4
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8b5104               | mov                 edx, dword ptr [ecx + 4]
            //   8910                 | mov                 dword ptr [eax], edx

        $sequence_23 = { 83c404 8b4dfc 8901 eb64 8b45fc 8b08 }
            // n = 6, score = 300
            //   83c404               | add                 esp, 4
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   8901                 | mov                 dword ptr [ecx], eax
            //   eb64                 | jmp                 0x66
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b08                 | mov                 ecx, dword ptr [eax]

    condition:
        7 of them and filesize < 4634440
}