rule win_xxmm_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.xxmm."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.xxmm"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 895d08 47 81e7ff000080 7908 }
            // n = 4, score = 600
            //   895d08               | mov                 dword ptr [ebp + 8], ebx
            //   47                   | inc                 edi
            //   81e7ff000080         | and                 edi, 0x800000ff
            //   7908                 | jns                 0xa

        $sequence_1 = { 8a0408 8b55fc 320432 8806 46 ff4d08 759b }
            // n = 7, score = 600
            //   8a0408               | mov                 al, byte ptr [eax + ecx]
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   320432               | xor                 al, byte ptr [edx + esi]
            //   8806                 | mov                 byte ptr [esi], al
            //   46                   | inc                 esi
            //   ff4d08               | dec                 dword ptr [ebp + 8]
            //   759b                 | jne                 0xffffff9d

        $sequence_2 = { 23c3 013c08 eb1e 6683ff01 }
            // n = 4, score = 600
            //   23c3                 | and                 eax, ebx
            //   013c08               | add                 dword ptr [eax + ecx], edi
            //   eb1e                 | jmp                 0x20
            //   6683ff01             | cmp                 di, 1

        $sequence_3 = { 8b45f4 83c704 85c0 7406 }
            // n = 4, score = 600
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   83c704               | add                 edi, 4
            //   85c0                 | test                eax, eax
            //   7406                 | je                  8

        $sequence_4 = { 7580 8b45f8 2b4634 83bea400000000 8945fc 0f8481000000 8b96a0000000 }
            // n = 7, score = 600
            //   7580                 | jne                 0xffffff82
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   2b4634               | sub                 eax, dword ptr [esi + 0x34]
            //   83bea400000000       | cmp                 dword ptr [esi + 0xa4], 0
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   0f8481000000         | je                  0x87
            //   8b96a0000000         | mov                 edx, dword ptr [esi + 0xa0]

        $sequence_5 = { 8d040f 0fb610 035510 81e2ff000080 7908 }
            // n = 5, score = 600
            //   8d040f               | lea                 eax, [edi + ecx]
            //   0fb610               | movzx               edx, byte ptr [eax]
            //   035510               | add                 edx, dword ptr [ebp + 0x10]
            //   81e2ff000080         | and                 edx, 0x800000ff
            //   7908                 | jns                 0xa

        $sequence_6 = { 3bc1 0f8568feffff 8b733c 6a40 6800300000 03f3 ff7650 }
            // n = 7, score = 600
            //   3bc1                 | cmp                 eax, ecx
            //   0f8568feffff         | jne                 0xfffffe6e
            //   8b733c               | mov                 esi, dword ptr [ebx + 0x3c]
            //   6a40                 | push                0x40
            //   6800300000           | push                0x3000
            //   03f3                 | add                 esi, ebx
            //   ff7650               | push                dword ptr [esi + 0x50]

        $sequence_7 = { 23c3 66013c08 8b45e0 8345f402 85c0 }
            // n = 5, score = 600
            //   23c3                 | and                 eax, ebx
            //   66013c08             | add                 word ptr [eax + ecx], di
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8345f402             | add                 dword ptr [ebp - 0xc], 2
            //   85c0                 | test                eax, eax

        $sequence_8 = { 77b7 8b45f0 8b5dfc 33c9 394de4 7414 }
            // n = 6, score = 600
            //   77b7                 | ja                  0xffffffb9
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b5dfc               | mov                 ebx, dword ptr [ebp - 4]
            //   33c9                 | xor                 ecx, ecx
            //   394de4               | cmp                 dword ptr [ebp - 0x1c], ecx
            //   7414                 | je                  0x16

        $sequence_9 = { 8945fc e8???????? 8b45fc 6800240000 bf???????? 03c3 57 }
            // n = 7, score = 600
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   e8????????           |                     
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   6800240000           | push                0x2400
            //   bf????????           |                     
            //   03c3                 | add                 eax, ebx
            //   57                   | push                edi

    condition:
        7 of them and filesize < 540672
}