rule win_yarat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.yarat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.yarat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b07 51 03f0 52 56 e8???????? 8b8564feffff }
            // n = 7, score = 100
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   51                   | push                ecx
            //   03f0                 | add                 esi, eax
            //   52                   | push                edx
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b8564feffff         | mov                 eax, dword ptr [ebp - 0x19c]

        $sequence_1 = { 8b7d08 33f6 33db 85ff 7439 8bf7 8d4e01 }
            // n = 7, score = 100
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   33f6                 | xor                 esi, esi
            //   33db                 | xor                 ebx, ebx
            //   85ff                 | test                edi, edi
            //   7439                 | je                  0x3b
            //   8bf7                 | mov                 esi, edi
            //   8d4e01               | lea                 ecx, [esi + 1]

        $sequence_2 = { c1ca03 663bf5 84eb 81f21b6f5a16 f7da f5 81fede018b2e }
            // n = 7, score = 100
            //   c1ca03               | ror                 edx, 3
            //   663bf5               | cmp                 si, bp
            //   84eb                 | test                bl, ch
            //   81f21b6f5a16         | xor                 edx, 0x165a6f1b
            //   f7da                 | neg                 edx
            //   f5                   | cmc                 
            //   81fede018b2e         | cmp                 esi, 0x2e8b01de

        $sequence_3 = { 8b3f 85ff 75d7 837c241c00 8b3d???????? 754f 6804010000 }
            // n = 7, score = 100
            //   8b3f                 | mov                 edi, dword ptr [edi]
            //   85ff                 | test                edi, edi
            //   75d7                 | jne                 0xffffffd9
            //   837c241c00           | cmp                 dword ptr [esp + 0x1c], 0
            //   8b3d????????         |                     
            //   754f                 | jne                 0x51
            //   6804010000           | push                0x104

        $sequence_4 = { f5 81c702000000 6685f1 0fadc2 f6d0 0f42c5 0fc8 }
            // n = 7, score = 100
            //   f5                   | cmc                 
            //   81c702000000         | add                 edi, 2
            //   6685f1               | test                cx, si
            //   0fadc2               | shrd                edx, eax, cl
            //   f6d0                 | not                 al
            //   0f42c5               | cmovb               eax, ebp
            //   0fc8                 | bswap               eax

        $sequence_5 = { b90a000000 5f 5e 89889c0a0000 8bc3 5b 8be5 }
            // n = 7, score = 100
            //   b90a000000           | mov                 ecx, 0xa
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   89889c0a0000         | mov                 dword ptr [eax + 0xa9c], ecx
            //   8bc3                 | mov                 eax, ebx
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp

        $sequence_6 = { e8???????? 83c408 eb02 33c0 898388050000 80be3e10000000 8945f8 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   898388050000         | mov                 dword ptr [ebx + 0x588], eax
            //   80be3e10000000       | cmp                 byte ptr [esi + 0x103e], 0
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_7 = { 8bec 8b4d08 85c9 7413 8b8148050000 8b4024 85c0 }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   85c9                 | test                ecx, ecx
            //   7413                 | je                  0x15
            //   8b8148050000         | mov                 eax, dword ptr [ecx + 0x548]
            //   8b4024               | mov                 eax, dword ptr [eax + 0x24]
            //   85c0                 | test                eax, eax

        $sequence_8 = { e8???????? 8bc6 83c418 0b45e8 0f858d000000 eb78 6a02 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8bc6                 | mov                 eax, esi
            //   83c418               | add                 esp, 0x18
            //   0b45e8               | or                  eax, dword ptr [ebp - 0x18]
            //   0f858d000000         | jne                 0x93
            //   eb78                 | jmp                 0x7a
            //   6a02                 | push                2

        $sequence_9 = { 869d56f9247d 9e 2490 7f7c ec 96 ac }
            // n = 7, score = 100
            //   869d56f9247d         | xchg                byte ptr [ebp + 0x7d24f956], bl
            //   9e                   | sahf                
            //   2490                 | and                 al, 0x90
            //   7f7c                 | jg                  0x7e
            //   ec                   | in                  al, dx
            //   96                   | xchg                eax, esi
            //   ac                   | lodsb               al, byte ptr [esi]

    condition:
        7 of them and filesize < 8692736
}