rule win_yayih_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.yayih."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.yayih"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a01 8d459c 5f 6689b548ffffff 50 }
            // n = 5, score = 100
            //   6a01                 | push                1
            //   8d459c               | lea                 eax, [ebp - 0x64]
            //   5f                   | pop                 edi
            //   6689b548ffffff       | mov                 word ptr [ebp - 0xb8], si
            //   50                   | push                eax

        $sequence_1 = { ff75f8 ff15???????? 8d85bcd8ffff 50 e8???????? 80bc05bbd8ffff3e }
            // n = 6, score = 100
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ff15????????         |                     
            //   8d85bcd8ffff         | lea                 eax, [ebp - 0x2744]
            //   50                   | push                eax
            //   e8????????           |                     
            //   80bc05bbd8ffff3e     | cmp                 byte ptr [ebp + eax - 0x2745], 0x3e

        $sequence_2 = { 8a1c33 80eb03 ff4508 8819 49 }
            // n = 5, score = 100
            //   8a1c33               | mov                 bl, byte ptr [ebx + esi]
            //   80eb03               | sub                 bl, 3
            //   ff4508               | inc                 dword ptr [ebp + 8]
            //   8819                 | mov                 byte ptr [ecx], bl
            //   49                   | dec                 ecx

        $sequence_3 = { e8???????? 59 59 8d85f0fdffff 68???????? }
            // n = 5, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8d85f0fdffff         | lea                 eax, [ebp - 0x210]
            //   68????????           |                     

        $sequence_4 = { 7517 ff45e0 817de050c30000 0f8cecfdffff 33f6 e9???????? 6a44 }
            // n = 7, score = 100
            //   7517                 | jne                 0x19
            //   ff45e0               | inc                 dword ptr [ebp - 0x20]
            //   817de050c30000       | cmp                 dword ptr [ebp - 0x20], 0xc350
            //   0f8cecfdffff         | jl                  0xfffffdf2
            //   33f6                 | xor                 esi, esi
            //   e9????????           |                     
            //   6a44                 | push                0x44

        $sequence_5 = { 83650800 8b550c 8d78ff 59 85ff }
            // n = 5, score = 100
            //   83650800             | and                 dword ptr [ebp + 8], 0
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8d78ff               | lea                 edi, [eax - 1]
            //   59                   | pop                 ecx
            //   85ff                 | test                edi, edi

        $sequence_6 = { 8d8570fdffff 68???????? 50 ff15???????? 83c410 3bc3 894508 }
            // n = 7, score = 100
            //   8d8570fdffff         | lea                 eax, [ebp - 0x290]
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   83c410               | add                 esp, 0x10
            //   3bc3                 | cmp                 eax, ebx
            //   894508               | mov                 dword ptr [ebp + 8], eax

        $sequence_7 = { 50 56 ff15???????? bf04010000 }
            // n = 4, score = 100
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   bf04010000           | mov                 edi, 0x104

        $sequence_8 = { c785f0feffff28000000 6a0c 8d45d0 56 50 e8???????? 6801200000 }
            // n = 7, score = 100
            //   c785f0feffff28000000     | mov    dword ptr [ebp - 0x110], 0x28
            //   6a0c                 | push                0xc
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   56                   | push                esi
            //   50                   | push                eax
            //   e8????????           |                     
            //   6801200000           | push                0x2001

        $sequence_9 = { 68???????? 50 e8???????? 59 8d85c0feffff 59 50 }
            // n = 7, score = 100
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8d85c0feffff         | lea                 eax, [ebp - 0x140]
            //   59                   | pop                 ecx
            //   50                   | push                eax

    condition:
        7 of them and filesize < 57344
}