rule win_yoddos_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.yoddos."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.yoddos"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 034508 57 53 894508 8d85d0feffff 50 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   034508               | add                 eax, dword ptr [ebp + 8]
            //   57                   | push                edi
            //   53                   | push                ebx
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   8d85d0feffff         | lea                 eax, [ebp - 0x130]
            //   50                   | push                eax

        $sequence_1 = { e8???????? 59 59 50 ff75bc ff75b8 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   50                   | push                eax
            //   ff75bc               | push                dword ptr [ebp - 0x44]
            //   ff75b8               | push                dword ptr [ebp - 0x48]
            //   e8????????           |                     

        $sequence_2 = { 83c44c 8d85bcf6ffff 50 8d85bcfaffff }
            // n = 4, score = 100
            //   83c44c               | add                 esp, 0x4c
            //   8d85bcf6ffff         | lea                 eax, [ebp - 0x944]
            //   50                   | push                eax
            //   8d85bcfaffff         | lea                 eax, [ebp - 0x544]

        $sequence_3 = { c68530ffffff77 c68531ffffff77 c68532ffffff77 c68533ffffff2e }
            // n = 4, score = 100
            //   c68530ffffff77       | mov                 byte ptr [ebp - 0xd0], 0x77
            //   c68531ffffff77       | mov                 byte ptr [ebp - 0xcf], 0x77
            //   c68532ffffff77       | mov                 byte ptr [ebp - 0xce], 0x77
            //   c68533ffffff2e       | mov                 byte ptr [ebp - 0xcd], 0x2e

        $sequence_4 = { c645e374 c645e465 c645e546 c645e669 }
            // n = 4, score = 100
            //   c645e374             | mov                 byte ptr [ebp - 0x1d], 0x74
            //   c645e465             | mov                 byte ptr [ebp - 0x1c], 0x65
            //   c645e546             | mov                 byte ptr [ebp - 0x1b], 0x46
            //   c645e669             | mov                 byte ptr [ebp - 0x1a], 0x69

        $sequence_5 = { 50 e8???????? 8d85c8feffff 50 e8???????? 83c410 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d85c8feffff         | lea                 eax, [ebp - 0x138]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10

        $sequence_6 = { c645db54 c645dc45 c645dd4d c645de5c c645df43 c645e075 c645e172 }
            // n = 7, score = 100
            //   c645db54             | mov                 byte ptr [ebp - 0x25], 0x54
            //   c645dc45             | mov                 byte ptr [ebp - 0x24], 0x45
            //   c645dd4d             | mov                 byte ptr [ebp - 0x23], 0x4d
            //   c645de5c             | mov                 byte ptr [ebp - 0x22], 0x5c
            //   c645df43             | mov                 byte ptr [ebp - 0x21], 0x43
            //   c645e075             | mov                 byte ptr [ebp - 0x20], 0x75
            //   c645e172             | mov                 byte ptr [ebp - 0x1f], 0x72

        $sequence_7 = { c645fa74 c645fb6c 885dfc c645e857 c645e953 c645ea32 c645eb5f }
            // n = 7, score = 100
            //   c645fa74             | mov                 byte ptr [ebp - 6], 0x74
            //   c645fb6c             | mov                 byte ptr [ebp - 5], 0x6c
            //   885dfc               | mov                 byte ptr [ebp - 4], bl
            //   c645e857             | mov                 byte ptr [ebp - 0x18], 0x57
            //   c645e953             | mov                 byte ptr [ebp - 0x17], 0x53
            //   c645ea32             | mov                 byte ptr [ebp - 0x16], 0x32
            //   c645eb5f             | mov                 byte ptr [ebp - 0x15], 0x5f

        $sequence_8 = { ffd7 8d8d58ffffff 8945fc 51 50 c68558ffffff49 c68559ffffff6e }
            // n = 7, score = 100
            //   ffd7                 | call                edi
            //   8d8d58ffffff         | lea                 ecx, [ebp - 0xa8]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   51                   | push                ecx
            //   50                   | push                eax
            //   c68558ffffff49       | mov                 byte ptr [ebp - 0xa8], 0x49
            //   c68559ffffff6e       | mov                 byte ptr [ebp - 0xa7], 0x6e

        $sequence_9 = { 7e06 897db4 8945ac 8d8548feffff 50 }
            // n = 5, score = 100
            //   7e06                 | jle                 8
            //   897db4               | mov                 dword ptr [ebp - 0x4c], edi
            //   8945ac               | mov                 dword ptr [ebp - 0x54], eax
            //   8d8548feffff         | lea                 eax, [ebp - 0x1b8]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 557056
}