rule win_yokai_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.yokai."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.yokai"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83780400 7f5e 8b4d14 83790400 7514 8b5514 8b4208 }
            // n = 7, score = 100
            //   83780400             | cmp                 dword ptr [eax + 4], 0
            //   7f5e                 | jg                  0x60
            //   8b4d14               | mov                 ecx, dword ptr [ebp + 0x14]
            //   83790400             | cmp                 dword ptr [ecx + 4], 0
            //   7514                 | jne                 0x16
            //   8b5514               | mov                 edx, dword ptr [ebp + 0x14]
            //   8b4208               | mov                 eax, dword ptr [edx + 8]

        $sequence_1 = { 8945fc 837dfc00 751e 8b55fc 8955b4 8d4df4 e8???????? }
            // n = 7, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   837dfc00             | cmp                 dword ptr [ebp - 4], 0
            //   751e                 | jne                 0x20
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8955b4               | mov                 dword ptr [ebp - 0x4c], edx
            //   8d4df4               | lea                 ecx, [ebp - 0xc]
            //   e8????????           |                     

        $sequence_2 = { 8b4d24 51 6a00 6a7e 68???????? 68???????? 68???????? }
            // n = 7, score = 100
            //   8b4d24               | mov                 ecx, dword ptr [ebp + 0x24]
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   6a7e                 | push                0x7e
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     

        $sequence_3 = { c645ac4c c645ad6f c645ae61 c645af64 c645b04c c645b169 c645b262 }
            // n = 7, score = 100
            //   c645ac4c             | mov                 byte ptr [ebp - 0x54], 0x4c
            //   c645ad6f             | mov                 byte ptr [ebp - 0x53], 0x6f
            //   c645ae61             | mov                 byte ptr [ebp - 0x52], 0x61
            //   c645af64             | mov                 byte ptr [ebp - 0x51], 0x64
            //   c645b04c             | mov                 byte ptr [ebp - 0x50], 0x4c
            //   c645b169             | mov                 byte ptr [ebp - 0x4f], 0x69
            //   c645b262             | mov                 byte ptr [ebp - 0x4e], 0x62

        $sequence_4 = { e8???????? 6a00 6a00 6a00 8d85a0fdffff 50 6a00 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8d85a0fdffff         | lea                 eax, [ebp - 0x260]
            //   50                   | push                eax
            //   6a00                 | push                0

        $sequence_5 = { 0345d4 a3???????? 8b4dec 8b15???????? 2b5114 8915???????? 8b450c }
            // n = 7, score = 100
            //   0345d4               | add                 eax, dword ptr [ebp - 0x2c]
            //   a3????????           |                     
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   8b15????????         |                     
            //   2b5114               | sub                 edx, dword ptr [ecx + 0x14]
            //   8915????????         |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_6 = { 8945c0 8b4dc0 898d70ffffff 8d9570ffffff 52 8d45d0 50 }
            // n = 7, score = 100
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax
            //   8b4dc0               | mov                 ecx, dword ptr [ebp - 0x40]
            //   898d70ffffff         | mov                 dword ptr [ebp - 0x90], ecx
            //   8d9570ffffff         | lea                 edx, [ebp - 0x90]
            //   52                   | push                edx
            //   8d45d0               | lea                 eax, [ebp - 0x30]
            //   50                   | push                eax

        $sequence_7 = { 8a11 8855ff 8b45f8 8b480c 83c101 8b55f8 894a0c }
            // n = 7, score = 100
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   8855ff               | mov                 byte ptr [ebp - 1], dl
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b480c               | mov                 ecx, dword ptr [eax + 0xc]
            //   83c101               | add                 ecx, 1
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   894a0c               | mov                 dword ptr [edx + 0xc], ecx

        $sequence_8 = { 8d0c50 894df8 e8???????? c5fe7f4580 8b530c 2b55ec }
            // n = 6, score = 100
            //   8d0c50               | lea                 ecx, [eax + edx*2]
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   e8????????           |                     
            //   c5fe7f4580           | vmovdqu             ymmword ptr [ebp - 0x80], ymm0
            //   8b530c               | mov                 edx, dword ptr [ebx + 0xc]
            //   2b55ec               | sub                 edx, dword ptr [ebp - 0x14]

        $sequence_9 = { ff15???????? 3bf4 e8???????? 50 a1???????? 83c004 50 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   3bf4                 | cmp                 esi, esp
            //   e8????????           |                     
            //   50                   | push                eax
            //   a1????????           |                     
            //   83c004               | add                 eax, 4
            //   50                   | push                eax

    condition:
        7 of them and filesize < 2066432
}