rule win_yorekey_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.yorekey."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.yorekey"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 750a 85c0 7506 ff15???????? }
            // n = 4, score = 200
            //   750a                 | jne                 0xc
            //   85c0                 | test                eax, eax
            //   7506                 | jne                 8
            //   ff15????????         |                     

        $sequence_1 = { 4881ec80000000 488b05???????? 4833c4 488945f0 488d55a0 }
            // n = 5, score = 100
            //   4881ec80000000       | mov                 eax, edi
            //   488b05????????       |                     
            //   4833c4               | mov                 byte ptr [eax + ebx], 0
            //   488945f0             | inc                 ebp
            //   488d55a0             | dec                 ecx

        $sequence_2 = { a1???????? 8bd0 83f910 7305 ba???????? }
            // n = 5, score = 100
            //   a1????????           |                     
            //   8bd0                 | lea                 edx, [0x13ff5]
            //   83f910               | dec                 eax
            //   7305                 | mov                 dword ptr [esp + 0x20], ecx
            //   ba????????           |                     

        $sequence_3 = { 3da1000000 761b 3da3000000 7714 }
            // n = 4, score = 100
            //   3da1000000           | dec                 eax
            //   761b                 | lea                 edx, [ebp - 0x60]
            //   3da3000000           | dec                 eax
            //   7714                 | mov                 eax, dword ptr [ebx + 8]

        $sequence_4 = { 488bc7 c6041800 ffc5 49ffc6 }
            // n = 4, score = 100
            //   488bc7               | mov                 dword ptr [esp + 0x60], eax
            //   c6041800             | mov                 byte ptr [esp + ebx + 0x2f], dl
            //   ffc5                 | dec                 eax
            //   49ffc6               | cmp                 ebx, 0x100

        $sequence_5 = { 488b05???????? 4833c4 4889442458 8b01 488bf9 }
            // n = 5, score = 100
            //   488b05????????       |                     
            //   4833c4               | lea                 eax, [esp + 0x30]
            //   4889442458           | dec                 esp
            //   8b01                 | mov                 ecx, esi
            //   488bf9               | dec                 eax

        $sequence_6 = { 88541c2f 4881fb00010000 72dd 8b5704 8b0f 4c8d442430 4c8bce }
            // n = 7, score = 100
            //   88541c2f             | dec                 eax
            //   4881fb00010000       | mov                 dword ptr [esp + 0x50], eax
            //   72dd                 | dec                 eax
            //   8b5704               | mov                 eax, dword ptr [ebp + 0x4f0]
            //   8b0f                 | dec                 esp
            //   4c8d442430           | lea                 eax, [esp + 0x30]
            //   4c8bce               | dec                 eax

        $sequence_7 = { 8bd9 7418 488d0df7f50000 e8???????? 85c0 7408 }
            // n = 6, score = 100
            //   8bd9                 | mov                 ebx, ecx
            //   7418                 | je                  0x1a
            //   488d0df7f50000       | dec                 eax
            //   e8????????           |                     
            //   85c0                 | lea                 ecx, [0xf5f7]
            //   7408                 | test                eax, eax

        $sequence_8 = { 50 56 8d8c240c080000 51 52 ffd7 }
            // n = 6, score = 100
            //   50                   | dec                 eax
            //   56                   | sub                 esp, 0x80
            //   8d8c240c080000       | dec                 eax
            //   51                   | xor                 eax, esp
            //   52                   | dec                 eax
            //   ffd7                 | mov                 dword ptr [ebp - 0x10], eax

        $sequence_9 = { 8955f0 0fbe13 52 894dec 8b0d???????? 8945f4 8d45e4 }
            // n = 7, score = 100
            //   8955f0               | lea                 edi, [ebp - 0x68]
            //   0fbe13               | push                eax
            //   52                   | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   894dec               | push                eax
            //   8b0d????????         |                     
            //   8945f4               | push                esi
            //   8d45e4               | lea                 ecx, [esp + 0x80c]

        $sequence_10 = { 8d4598 b919000000 be???????? 8d7d98 50 f3a5 ff15???????? }
            // n = 7, score = 100
            //   8d4598               | dec                 eax
            //   b919000000           | mov                 dword ptr [esp + 0x58], eax
            //   be????????           |                     
            //   8d7d98               | mov                 eax, dword ptr [ecx]
            //   50                   | dec                 eax
            //   f3a5                 | mov                 edi, ecx
            //   ff15????????         |                     

        $sequence_11 = { 68ff000000 e8???????? 59 59 8b7508 8d34f5d8194100 }
            // n = 6, score = 100
            //   68ff000000           | jne                 0xc
            //   e8????????           |                     
            //   59                   | test                eax, eax
            //   59                   | jne                 8
            //   8b7508               | lea                 eax, [ebp - 0x68]
            //   8d34f5d8194100       | mov                 ecx, 0x19

        $sequence_12 = { 0fbe84c140e14000 6a07 c1f804 59 }
            // n = 4, score = 100
            //   0fbe84c140e14000     | dec                 eax
            //   6a07                 | test                eax, eax
            //   c1f804               | je                  0x41
            //   59                   | dec                 eax

        $sequence_13 = { cc 488d0de61f0100 e8???????? cc 85f6 }
            // n = 5, score = 100
            //   cc                   | jb                  0xffffffdf
            //   488d0de61f0100       | mov                 edx, dword ptr [edi + 4]
            //   e8????????           |                     
            //   cc                   | mov                 ecx, dword ptr [edi]
            //   85f6                 | dec                 esp

        $sequence_14 = { 488b13 498b0f 488d0549470000 4889442450 488b85f0040000 4c8d442430 4889442460 }
            // n = 7, score = 100
            //   488b13               | je                  0xa
            //   498b0f               | dec                 eax
            //   488d0549470000       | mov                 edx, dword ptr [ebx]
            //   4889442450           | dec                 ecx
            //   488b85f0040000       | mov                 ecx, dword ptr [edi]
            //   4c8d442430           | dec                 eax
            //   4889442460           | lea                 eax, [0x4749]

    condition:
        7 of them and filesize < 274432
}