rule win_yty_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.yty."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.yty"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f840c000000 8365d8fe 8b7508 e9???????? c3 8b542408 8d420c }
            // n = 7, score = 500
            //   0f840c000000         | je                  0x12
            //   8365d8fe             | and                 dword ptr [ebp - 0x28], 0xfffffffe
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   e9????????           |                     
            //   c3                   | ret                 
            //   8b542408             | mov                 edx, dword ptr [esp + 8]
            //   8d420c               | lea                 eax, [edx + 0xc]

        $sequence_1 = { 64a300000000 8b7508 33ff 897dd8 }
            // n = 4, score = 500
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   33ff                 | xor                 edi, edi
            //   897dd8               | mov                 dword ptr [ebp - 0x28], edi

        $sequence_2 = { 8b5610 33c9 33c0 8d7910 }
            // n = 4, score = 400
            //   8b5610               | mov                 edx, dword ptr [esi + 0x10]
            //   33c9                 | xor                 ecx, ecx
            //   33c0                 | xor                 eax, eax
            //   8d7910               | lea                 edi, [ecx + 0x10]

        $sequence_3 = { b901000000 e9???????? 8b5508 397d1c 7303 8d5508 }
            // n = 6, score = 400
            //   b901000000           | mov                 ecx, 1
            //   e9????????           |                     
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   397d1c               | cmp                 dword ptr [ebp + 0x1c], edi
            //   7303                 | jae                 5
            //   8d5508               | lea                 edx, [ebp + 8]

        $sequence_4 = { 5f 668910 8bc6 5b 8be5 5d c20400 }
            // n = 7, score = 400
            //   5f                   | pop                 edi
            //   668910               | mov                 word ptr [eax], dx
            //   8bc6                 | mov                 eax, esi
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4

        $sequence_5 = { 8bfe 80ea13 b903000000 eb58 }
            // n = 4, score = 400
            //   8bfe                 | mov                 edi, esi
            //   80ea13               | sub                 dl, 0x13
            //   b903000000           | mov                 ecx, 3
            //   eb58                 | jmp                 0x5a

        $sequence_6 = { 8b4c3138 33db 895de8 885def 8975e0 85c9 }
            // n = 6, score = 400
            //   8b4c3138             | mov                 ecx, dword ptr [ecx + esi + 0x38]
            //   33db                 | xor                 ebx, ebx
            //   895de8               | mov                 dword ptr [ebp - 0x18], ebx
            //   885def               | mov                 byte ptr [ebp - 0x11], bl
            //   8975e0               | mov                 dword ptr [ebp - 0x20], esi
            //   85c9                 | test                ecx, ecx

        $sequence_7 = { 50 ffd2 ff15???????? 8a857bffffff 8b4df4 }
            // n = 5, score = 400
            //   50                   | push                eax
            //   ffd2                 | call                edx
            //   ff15????????         |                     
            //   8a857bffffff         | mov                 al, byte ptr [ebp - 0x85]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_8 = { 8b08 8b5108 50 ffd2 8b8568ffffff 8b08 }
            // n = 6, score = 400
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   8b5108               | mov                 edx, dword ptr [ecx + 8]
            //   50                   | push                eax
            //   ffd2                 | call                edx
            //   8b8568ffffff         | mov                 eax, dword ptr [ebp - 0x98]
            //   8b08                 | mov                 ecx, dword ptr [eax]

        $sequence_9 = { c645fc01 e8???????? 8b10 8b4a04 03c8 }
            // n = 5, score = 400
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   e8????????           |                     
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8b4a04               | mov                 ecx, dword ptr [edx + 4]
            //   03c8                 | add                 ecx, eax

        $sequence_10 = { 807def00 8b5de8 7503 83cb02 8b16 8b4a04 }
            // n = 6, score = 400
            //   807def00             | cmp                 byte ptr [ebp - 0x11], 0
            //   8b5de8               | mov                 ebx, dword ptr [ebp - 0x18]
            //   7503                 | jne                 5
            //   83cb02               | or                  ebx, 2
            //   8b16                 | mov                 edx, dword ptr [esi]
            //   8b4a04               | mov                 ecx, dword ptr [edx + 4]

        $sequence_11 = { 8bcf e8???????? 8b0e 8b5104 8b443238 }
            // n = 5, score = 400
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   8b5104               | mov                 edx, dword ptr [ecx + 4]
            //   8b443238             | mov                 eax, dword ptr [edx + esi + 0x38]

        $sequence_12 = { 8906 894604 894608 8945fc 56 c745f001000000 }
            // n = 6, score = 400
            //   8906                 | mov                 dword ptr [esi], eax
            //   894604               | mov                 dword ptr [esi + 4], eax
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   56                   | push                esi
            //   c745f001000000       | mov                 dword ptr [ebp - 0x10], 1

        $sequence_13 = { 8bfe 80ea04 b904000000 eb23 }
            // n = 4, score = 400
            //   8bfe                 | mov                 edi, esi
            //   80ea04               | sub                 dl, 4
            //   b904000000           | mov                 ecx, 4
            //   eb23                 | jmp                 0x25

        $sequence_14 = { 397e14 7214 8a1402 8b3e 2ad1 }
            // n = 5, score = 400
            //   397e14               | cmp                 dword ptr [esi + 0x14], edi
            //   7214                 | jb                  0x16
            //   8a1402               | mov                 dl, byte ptr [edx + eax]
            //   8b3e                 | mov                 edi, dword ptr [esi]
            //   2ad1                 | sub                 dl, cl

        $sequence_15 = { 7204 8b3e eb02 8bfe 8a1402 2ad1 80ea13 }
            // n = 7, score = 400
            //   7204                 | jb                  6
            //   8b3e                 | mov                 edi, dword ptr [esi]
            //   eb02                 | jmp                 4
            //   8bfe                 | mov                 edi, esi
            //   8a1402               | mov                 dl, byte ptr [edx + eax]
            //   2ad1                 | sub                 dl, cl
            //   80ea13               | sub                 dl, 0x13

        $sequence_16 = { 51 e8???????? 83c408 8bf0 6a0a }
            // n = 5, score = 400
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8bf0                 | mov                 esi, eax
            //   6a0a                 | push                0xa

        $sequence_17 = { 50 e8???????? 83c40c 8d8de8fdffff 51 53 }
            // n = 6, score = 400
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d8de8fdffff         | lea                 ecx, [ebp - 0x218]
            //   51                   | push                ecx
            //   53                   | push                ebx

        $sequence_18 = { 50 8bce c60600 e8???????? 8b5610 33c9 }
            // n = 6, score = 400
            //   50                   | push                eax
            //   8bce                 | mov                 ecx, esi
            //   c60600               | mov                 byte ptr [esi], 0
            //   e8????????           |                     
            //   8b5610               | mov                 edx, dword ptr [esi + 0x10]
            //   33c9                 | xor                 ecx, ecx

        $sequence_19 = { 8d8de8fdffff 51 53 53 6a28 53 }
            // n = 6, score = 400
            //   8d8de8fdffff         | lea                 ecx, [ebp - 0x218]
            //   51                   | push                ecx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6a28                 | push                0x28
            //   53                   | push                ebx

        $sequence_20 = { 33c9 881407 bf10000000 40 3b4610 }
            // n = 5, score = 400
            //   33c9                 | xor                 ecx, ecx
            //   881407               | mov                 byte ptr [edi + eax], dl
            //   bf10000000           | mov                 edi, 0x10
            //   40                   | inc                 eax
            //   3b4610               | cmp                 eax, dword ptr [esi + 0x10]

        $sequence_21 = { c0ea02 8ac4 80e20f c0e004 }
            // n = 4, score = 300
            //   c0ea02               | shr                 dl, 2
            //   8ac4                 | mov                 al, ah
            //   80e20f               | and                 dl, 0xf
            //   c0e004               | shl                 al, 4

        $sequence_22 = { 8b07 eb02 8bc7 8b4de0 }
            // n = 4, score = 300
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   eb02                 | jmp                 4
            //   8bc7                 | mov                 eax, edi
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]

        $sequence_23 = { c645fc07 e8???????? 8bf0 891f 6a08 c645fc0c e8???????? }
            // n = 7, score = 200
            //   c645fc07             | mov                 byte ptr [ebp - 4], 7
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   891f                 | mov                 dword ptr [edi], ebx
            //   6a08                 | push                8
            //   c645fc0c             | mov                 byte ptr [ebp - 4], 0xc
            //   e8????????           |                     

        $sequence_24 = { 8b4c1938 895dd4 85c9 7405 8b01 ff5004 c745fc00000000 }
            // n = 7, score = 200
            //   8b4c1938             | mov                 ecx, dword ptr [ecx + ebx + 0x38]
            //   895dd4               | mov                 dword ptr [ebp - 0x2c], ebx
            //   85c9                 | test                ecx, ecx
            //   7405                 | je                  7
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff5004               | call                dword ptr [eax + 4]
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

        $sequence_25 = { 25ff000000 83c001 25fe010000 f20f593c85c0014600 660f122c85c0014600 }
            // n = 5, score = 100
            //   25ff000000           | and                 eax, 0xff
            //   83c001               | add                 eax, 1
            //   25fe010000           | and                 eax, 0x1fe
            //   f20f593c85c0014600     | mulsd    xmm7, qword ptr [eax*4 + 0x4601c0]
            //   660f122c85c0014600     | movlpd    xmm5, qword ptr [eax*4 + 0x4601c0]

        $sequence_26 = { c70424???????? e8???????? 85c0 7424 c70424f4010000 e8???????? 83ec04 }
            // n = 7, score = 100
            //   c70424????????       |                     
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7424                 | je                  0x26
            //   c70424f4010000       | mov                 dword ptr [esp], 0x1f4
            //   e8????????           |                     
            //   83ec04               | sub                 esp, 4

        $sequence_27 = { 8b5508 83e23f 6bd230 8b0c8d00b04600 88441128 e9???????? 8b5508 }
            // n = 7, score = 100
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   83e23f               | and                 edx, 0x3f
            //   6bd230               | imul                edx, edx, 0x30
            //   8b0c8d00b04600       | mov                 ecx, dword ptr [ecx*4 + 0x46b000]
            //   88441128             | mov                 byte ptr [ecx + edx + 0x28], al
            //   e9????????           |                     
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]

        $sequence_28 = { c74410e05c584600 8b42e0 8b4804 8d41e8 894411dc c745fc00000000 }
            // n = 6, score = 100
            //   c74410e05c584600     | mov                 dword ptr [eax + edx - 0x20], 0x46585c
            //   8b42e0               | mov                 eax, dword ptr [edx - 0x20]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   8d41e8               | lea                 eax, [ecx - 0x18]
            //   894411dc             | mov                 dword ptr [ecx + edx - 0x24], eax
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0

        $sequence_29 = { 33f6 bf???????? 833cf584fe420001 751d 8d04f580fe4200 }
            // n = 5, score = 100
            //   33f6                 | xor                 esi, esi
            //   bf????????           |                     
            //   833cf584fe420001     | cmp                 dword ptr [esi*8 + 0x42fe84], 1
            //   751d                 | jne                 0x1f
            //   8d04f580fe4200       | lea                 eax, [esi*8 + 0x42fe80]

        $sequence_30 = { 0f1000 0f1105???????? f30f7e4010 660fd605???????? e8???????? 8d8590bcf0ff }
            // n = 6, score = 100
            //   0f1000               | movups              xmm0, xmmword ptr [eax]
            //   0f1105????????       |                     
            //   f30f7e4010           | movq                xmm0, qword ptr [eax + 0x10]
            //   660fd605????????     |                     
            //   e8????????           |                     
            //   8d8590bcf0ff         | lea                 eax, [ebp - 0xf4370]

        $sequence_31 = { 0bc8 51 e8???????? 83c404 8d8dd4efffff 83bde8efffff10 }
            // n = 6, score = 100
            //   0bc8                 | or                  ecx, eax
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8d8dd4efffff         | lea                 ecx, [ebp - 0x102c]
            //   83bde8efffff10       | cmp                 dword ptr [ebp - 0x1018], 0x10

        $sequence_32 = { 83e3fc ba00000000 898c15a4feffff 83c204 }
            // n = 4, score = 100
            //   83e3fc               | and                 ebx, 0xfffffffc
            //   ba00000000           | mov                 edx, 0
            //   898c15a4feffff       | mov                 dword ptr [ebp + edx - 0x15c], ecx
            //   83c204               | add                 edx, 4

        $sequence_33 = { 01c8 0fb600 38c2 7410 c745e401000000 c745e000000000 eb18 }
            // n = 7, score = 100
            //   01c8                 | add                 eax, ecx
            //   0fb600               | movzx               eax, byte ptr [eax]
            //   38c2                 | cmp                 dl, al
            //   7410                 | je                  0x12
            //   c745e401000000       | mov                 dword ptr [ebp - 0x1c], 1
            //   c745e000000000       | mov                 dword ptr [ebp - 0x20], 0
            //   eb18                 | jmp                 0x1a

        $sequence_34 = { 8d8588feffff 890424 e8???????? 8d85bafeffff }
            // n = 4, score = 100
            //   8d8588feffff         | lea                 eax, [ebp - 0x178]
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   8d85bafeffff         | lea                 eax, [ebp - 0x146]

        $sequence_35 = { c1fe05 c1e106 030cb5a0244300 eb02 8bca f641247f 759c }
            // n = 7, score = 100
            //   c1fe05               | sar                 esi, 5
            //   c1e106               | shl                 ecx, 6
            //   030cb5a0244300       | add                 ecx, dword ptr [esi*4 + 0x4324a0]
            //   eb02                 | jmp                 4
            //   8bca                 | mov                 ecx, edx
            //   f641247f             | test                byte ptr [ecx + 0x24], 0x7f
            //   759c                 | jne                 0xffffff9e

        $sequence_36 = { 39e8 741e c74424045c000000 893c24 }
            // n = 4, score = 100
            //   39e8                 | cmp                 eax, ebp
            //   741e                 | je                  0x20
            //   c74424045c000000     | mov                 dword ptr [esp + 4], 0x5c
            //   893c24               | mov                 dword ptr [esp], edi

        $sequence_37 = { c78534ffffff00000000 6a00 50 e8???????? 83c404 8d8d38ffffff e8???????? }
            // n = 7, score = 100
            //   c78534ffffff00000000     | mov    dword ptr [ebp - 0xcc], 0
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   8d8d38ffffff         | lea                 ecx, [ebp - 0xc8]
            //   e8????????           |                     

        $sequence_38 = { 3d04010000 7607 b801000000 eb33 c744240404010000 }
            // n = 5, score = 100
            //   3d04010000           | cmp                 eax, 0x104
            //   7607                 | jbe                 9
            //   b801000000           | mov                 eax, 1
            //   eb33                 | jmp                 0x35
            //   c744240404010000     | mov                 dword ptr [esp + 4], 0x104

        $sequence_39 = { 57 33ff ffb744fe4200 ff15???????? }
            // n = 4, score = 100
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   ffb744fe4200         | push                dword ptr [edi + 0x42fe44]
            //   ff15????????         |                     

        $sequence_40 = { 89e5 83ec28 c745eb00000000 c645ef00 c745f400000000 }
            // n = 5, score = 100
            //   89e5                 | mov                 ebp, esp
            //   83ec28               | sub                 esp, 0x28
            //   c745eb00000000       | mov                 dword ptr [ebp - 0x15], 0
            //   c645ef00             | mov                 byte ptr [ebp - 0x11], 0
            //   c745f400000000       | mov                 dword ptr [ebp - 0xc], 0

        $sequence_41 = { 6a40 6a00 8d8590fcffff 50 e8???????? 83c40c }
            // n = 6, score = 100
            //   6a40                 | push                0x40
            //   6a00                 | push                0
            //   8d8590fcffff         | lea                 eax, [ebp - 0x370]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_42 = { f3ab 8d4dfb e8???????? 8d4dfb e8???????? }
            // n = 5, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8d4dfb               | lea                 ecx, [ebp - 5]
            //   e8????????           |                     
            //   8d4dfb               | lea                 ecx, [ebp - 5]
            //   e8????????           |                     

        $sequence_43 = { 83f809 7d10 40 ba???????? 50 e8???????? }
            // n = 6, score = 100
            //   83f809               | cmp                 eax, 9
            //   7d10                 | jge                 0x12
            //   40                   | inc                 eax
            //   ba????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_44 = { 8bec 8b4508 ff34c580fe4200 ff15???????? }
            // n = 4, score = 100
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   ff34c580fe4200       | push                dword ptr [eax*8 + 0x42fe80]
            //   ff15????????         |                     

        $sequence_45 = { ff15???????? 8d8d90bcf0ff e8???????? 8bf0 c645fc03 }
            // n = 5, score = 100
            //   ff15????????         |                     
            //   8d8d90bcf0ff         | lea                 ecx, [ebp - 0xf4370]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   c645fc03             | mov                 byte ptr [ebp - 4], 3

        $sequence_46 = { 64a300000000 8b7510 56 ff15???????? 85c0 0f84cb010000 }
            // n = 6, score = 100
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8b7510               | mov                 esi, dword ptr [ebp + 0x10]
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f84cb010000         | je                  0x1d1

        $sequence_47 = { 83e13f 6bd130 8b048500b04600 807c102900 7536 8b4d0c 3b4d14 }
            // n = 7, score = 100
            //   83e13f               | and                 ecx, 0x3f
            //   6bd130               | imul                edx, ecx, 0x30
            //   8b048500b04600       | mov                 eax, dword ptr [eax*4 + 0x46b000]
            //   807c102900           | cmp                 byte ptr [eax + edx + 0x29], 0
            //   7536                 | jne                 0x38
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   3b4d14               | cmp                 ecx, dword ptr [ebp + 0x14]

        $sequence_48 = { 8b45ec 3b45e0 7517 8b4508 0345e0 894508 }
            // n = 6, score = 100
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   3b45e0               | cmp                 eax, dword ptr [ebp - 0x20]
            //   7517                 | jne                 0x19
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   0345e0               | add                 eax, dword ptr [ebp - 0x20]
            //   894508               | mov                 dword ptr [ebp + 8], eax

        $sequence_49 = { 8bf4 8b8578fcffff 50 ff15???????? 3bf4 e8???????? 8bf4 }
            // n = 7, score = 100
            //   8bf4                 | mov                 esi, esp
            //   8b8578fcffff         | mov                 eax, dword ptr [ebp - 0x388]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   3bf4                 | cmp                 esi, esp
            //   e8????????           |                     
            //   8bf4                 | mov                 esi, esp

        $sequence_50 = { 8b4d10 394de0 7752 037de0 8b45f0 8b55e8 8b048560cb4300 }
            // n = 7, score = 100
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   394de0               | cmp                 dword ptr [ebp - 0x20], ecx
            //   7752                 | ja                  0x54
            //   037de0               | add                 edi, dword ptr [ebp - 0x20]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   8b048560cb4300       | mov                 eax, dword ptr [eax*4 + 0x43cb60]

        $sequence_51 = { 6a01 e8???????? ebd7 85ff }
            // n = 4, score = 100
            //   6a01                 | push                1
            //   e8????????           |                     
            //   ebd7                 | jmp                 0xffffffd9
            //   85ff                 | test                edi, edi

        $sequence_52 = { 3c5a 770f 0fbec1 0fb680d0ed4200 83e00f eb02 33c0 }
            // n = 7, score = 100
            //   3c5a                 | cmp                 al, 0x5a
            //   770f                 | ja                  0x11
            //   0fbec1               | movsx               eax, cl
            //   0fb680d0ed4200       | movzx               eax, byte ptr [eax + 0x42edd0]
            //   83e00f               | and                 eax, 0xf
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax

        $sequence_53 = { e8???????? 85c0 756f 8b8328020000 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   756f                 | jne                 0x71
            //   8b8328020000         | mov                 eax, dword ptr [ebx + 0x228]

        $sequence_54 = { 898584fbffff 8d85e8fdffff 6808020000 50 }
            // n = 4, score = 100
            //   898584fbffff         | mov                 dword ptr [ebp - 0x47c], eax
            //   8d85e8fdffff         | lea                 eax, [ebp - 0x218]
            //   6808020000           | push                0x208
            //   50                   | push                eax

    condition:
        7 of them and filesize < 1097728
}