rule win_zardoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zardoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zardoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 740d c7442428ac070000 e9???????? f687d005000080 8b442468 410f44c1 81fa03030000 }
            // n = 7, score = 100
            //   740d                 | dec                 esp
            //   c7442428ac070000     | lea                 eax, [0x99494]
            //   e9????????           |                     
            //   f687d005000080       | dec                 ecx
            //   8b442468             | mov                 eax, edi
            //   410f44c1             | dec                 eax
            //   81fa03030000         | shr                 eax, 0x18

        $sequence_1 = { f6c210 752c eb0a f6c220 7405 4584c0 7920 }
            // n = 7, score = 100
            //   f6c210               | test                eax, eax
            //   752c                 | jne                 0x436
            //   eb0a                 | dec                 eax
            //   f6c220               | mov                 ecx, ebx
            //   7405                 | dec                 esp
            //   4584c0               | lea                 ecx, [0x105d3d]
            //   7920                 | mov                 dword ptr [esp + 0x20], 0x95

        $sequence_2 = { e8???????? 4889442448 4885c0 0f85c9000000 c74424201d010000 4c8d0d264f0b00 8d5566 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4889442448           | inc                 ebp
            //   4885c0               | mov                 esi, esp
            //   0f85c9000000         | dec                 esp
            //   c74424201d010000     | mov                 dword ptr [esp + 0x80], esp
            //   4c8d0d264f0b00       | movups              xmmword ptr [esp + 0x30], xmm0
            //   8d5566               | dec                 eax

        $sequence_3 = { ffc3 895c2430 e8???????? 3bd8 0f8c2cfeffff b801000000 488b9c2488000000 }
            // n = 7, score = 100
            //   ffc3                 | mov                 ecx, edi
            //   895c2430             | dec                 eax
            //   e8????????           |                     
            //   3bd8                 | mov                 esi, eax
            //   0f8c2cfeffff         | dec                 eax
            //   b801000000           | test                eax, eax
            //   488b9c2488000000     | je                  0x755

        $sequence_4 = { 488d1572b10900 488bcd e8???????? 85c0 0f8e29020000 488b13 4885d2 }
            // n = 7, score = 100
            //   488d1572b10900       | mov                 eax, 0x4140
            //   488bcd               | dec                 ecx
            //   e8????????           |                     
            //   85c0                 | mov                 edx, dword ptr [esi]
            //   0f8e29020000         | mov                 edx, 0x16
            //   488b13               | inc                 ecx
            //   4885d2               | mov                 ecx, 0xc6

        $sequence_5 = { e8???????? 4883c9ff 660f1f440000 48ffc1 803c0800 75f7 83c10d }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4883c9ff             | xor                 ecx, eax
            //   660f1f440000         | inc                 ebx
            //   48ffc1               | mov                 eax, dword ptr [ebp + edx*4 + 0x18aaa0]
            //   803c0800             | dec                 esp
            //   75f7                 | xor                 ecx, eax
            //   83c10d               | inc                 ecx

        $sequence_6 = { e8???????? 488906 4885c0 0f85ab000000 83c8ff 488b742458 488b5c2460 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488906               | mov                 edx, esi
            //   4885c0               | xor                 ecx, eax
            //   0f85ab000000         | inc                 ebp
            //   83c8ff               | xor                 edx, ebx
            //   488b742458           | inc                 esp
            //   488b5c2460           | and                 edx, esi

        $sequence_7 = { e8???????? 4885c0 8bde 0f95c3 e8???????? 85db 488b9c2440010000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4885c0               | mov                 ecx, ebx
            //   8bde                 | xor                 edx, eax
            //   0f95c3               | inc                 ecx
            //   e8????????           |                     
            //   85db                 | lea                 eax, [ebx - 2]
            //   488b9c2440010000     | xor                 edx, dword ptr [ecx]

        $sequence_8 = { 8bc3 448bcb 488bf9 448bc3 488bcb 4883f838 7317 }
            // n = 7, score = 100
            //   8bc3                 | cmp                 esp, ebx
            //   448bcb               | jle                 0x15e8
            //   488bf9               | nop                 dword ptr [eax]
            //   448bc3               | lea                 edx, [ebx - 2]
            //   488bcb               | dec                 ecx
            //   4883f838             | mov                 ecx, esi
            //   7317                 | inc                 ecx

        $sequence_9 = { e8???????? 85c0 0f84d1000000 4d8b8d90000000 488bd3 4c8b442440 488bcb }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | test                byte ptr [eax + 0x60], 8
            //   0f84d1000000         | jne                 0xd3e
            //   4d8b8d90000000       | mov                 eax, dword ptr [ecx]
            //   488bd3               | dec                 eax
            //   4c8b442440           | sub                 esp, eax
            //   488bcb               | dec                 esp

    condition:
        7 of them and filesize < 4376576
}