rule win_zebrocy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zebrocy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zebrocy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c605????????03 c705????????04000000 c605????????11 c705????????00000000 }
            // n = 4, score = 100
            //   c605????????03       |                     
            //   c705????????04000000     |     
            //   c605????????11       |                     
            //   c705????????00000000     |     

        $sequence_1 = { e8???????? 84c0 8b4de0 7507 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   7507                 | jne                 9

        $sequence_2 = { 50 8d45f4 64a300000000 6aff 33ff c745fc01000000 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   6aff                 | push                -1
            //   33ff                 | xor                 edi, edi
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1

        $sequence_3 = { 8be5 5d c21000 8b4d14 51 56 }
            // n = 6, score = 100
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c21000               | ret                 0x10
            //   8b4d14               | mov                 ecx, dword ptr [ebp + 0x14]
            //   51                   | push                ecx
            //   56                   | push                esi

        $sequence_4 = { e8???????? 83c41c 83ec1c 8bcc 89a5f4f4ffff }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   83ec1c               | sub                 esp, 0x1c
            //   8bcc                 | mov                 ecx, esp
            //   89a5f4f4ffff         | mov                 dword ptr [ebp - 0xb0c], esp

        $sequence_5 = { ff25???????? ebb5 55 b9???????? 89e5 }
            // n = 5, score = 100
            //   ff25????????         |                     
            //   ebb5                 | jmp                 0xffffffb7
            //   55                   | push                ebp
            //   b9????????           |                     
            //   89e5                 | mov                 ebp, esp

        $sequence_6 = { f2ae 89c8 f7d0 8d5402ff }
            // n = 4, score = 100
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   89c8                 | mov                 eax, ecx
            //   f7d0                 | not                 eax
            //   8d5402ff             | lea                 edx, [edx + eax - 1]

        $sequence_7 = { 8bd8 3bc7 7e63 8d642400 6a02 }
            // n = 5, score = 100
            //   8bd8                 | mov                 ebx, eax
            //   3bc7                 | cmp                 eax, edi
            //   7e63                 | jle                 0x65
            //   8d642400             | lea                 esp, [esp]
            //   6a02                 | push                2

        $sequence_8 = { 397de0 7f57 8b03 85c0 }
            // n = 4, score = 100
            //   397de0               | cmp                 dword ptr [ebp - 0x20], edi
            //   7f57                 | jg                  0x59
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   85c0                 | test                eax, eax

        $sequence_9 = { 8d45f4 64a300000000 33db 897d90 895d94 6aff c745fc01000000 }
            // n = 7, score = 100
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   33db                 | xor                 ebx, ebx
            //   897d90               | mov                 dword ptr [ebp - 0x70], edi
            //   895d94               | mov                 dword ptr [ebp - 0x6c], ebx
            //   6aff                 | push                -1
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1

        $sequence_10 = { 89d8 e8???????? 8d9510fcffff 89c6 8d8500fcffff 89d7 }
            // n = 6, score = 100
            //   89d8                 | mov                 eax, ebx
            //   e8????????           |                     
            //   8d9510fcffff         | lea                 edx, [ebp - 0x3f0]
            //   89c6                 | mov                 esi, eax
            //   8d8500fcffff         | lea                 eax, [ebp - 0x400]
            //   89d7                 | mov                 edi, edx

        $sequence_11 = { 89c7 eb2f 89f2 89d9 e8???????? }
            // n = 5, score = 100
            //   89c7                 | mov                 edi, eax
            //   eb2f                 | jmp                 0x31
            //   89f2                 | mov                 edx, esi
            //   89d9                 | mov                 ecx, ebx
            //   e8????????           |                     

        $sequence_12 = { 325032 7032 7c32 9c 32a432ac32c432 d432 e8???????? }
            // n = 7, score = 100
            //   325032               | xor                 dl, byte ptr [eax + 0x32]
            //   7032                 | jo                  0x34
            //   7c32                 | jl                  0x34
            //   9c                   | pushfd              
            //   32a432ac32c432       | xor                 ah, byte ptr [edx + esi + 0x32c432ac]
            //   d432                 | aam                 0x32
            //   e8????????           |                     

        $sequence_13 = { 33c0 894e14 894710 894714 c645fc00 837de810 720c }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   894e14               | mov                 dword ptr [esi + 0x14], ecx
            //   894710               | mov                 dword ptr [edi + 0x10], eax
            //   894714               | mov                 dword ptr [edi + 0x14], eax
            //   c645fc00             | mov                 byte ptr [ebp - 4], 0
            //   837de810             | cmp                 dword ptr [ebp - 0x18], 0x10
            //   720c                 | jb                  0xe

        $sequence_14 = { 66c705????????6046 8915???????? ba???????? a3???????? e8???????? }
            // n = 5, score = 100
            //   66c705????????6046     |     
            //   8915????????         |                     
            //   ba????????           |                     
            //   a3????????           |                     
            //   e8????????           |                     

        $sequence_15 = { 89b5c4f7ffff 899dc0f7ffff 889db0f7ffff 39bd38f7ffff }
            // n = 4, score = 100
            //   89b5c4f7ffff         | mov                 dword ptr [ebp - 0x83c], esi
            //   899dc0f7ffff         | mov                 dword ptr [ebp - 0x840], ebx
            //   889db0f7ffff         | mov                 byte ptr [ebp - 0x850], bl
            //   39bd38f7ffff         | cmp                 dword ptr [ebp - 0x8c8], edi

    condition:
        7 of them and filesize < 393216
}