rule win_zedhou_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zedhou."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zedhou"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 03c8 8d954cfdffff 51 8d8550fcffff 52 50 68???????? }
            // n = 7, score = 100
            //   03c8                 | add                 ecx, eax
            //   8d954cfdffff         | lea                 edx, [ebp - 0x2b4]
            //   51                   | push                ecx
            //   8d8550fcffff         | lea                 eax, [ebp - 0x3b0]
            //   52                   | push                edx
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_1 = { 50 0f80d8000000 51 52 e8???????? ffd7 8b85d4feffff }
            // n = 7, score = 100
            //   50                   | push                eax
            //   0f80d8000000         | jo                  0xde
            //   51                   | push                ecx
            //   52                   | push                edx
            //   e8????????           |                     
            //   ffd7                 | call                edi
            //   8b85d4feffff         | mov                 eax, dword ptr [ebp - 0x12c]

        $sequence_2 = { 68???????? ff15???????? 8bd0 8d8d70ffffff ff15???????? 50 8d956cffffff }
            // n = 7, score = 100
            //   68????????           |                     
            //   ff15????????         |                     
            //   8bd0                 | mov                 edx, eax
            //   8d8d70ffffff         | lea                 ecx, [ebp - 0x90]
            //   ff15????????         |                     
            //   50                   | push                eax
            //   8d956cffffff         | lea                 edx, [ebp - 0x94]

        $sequence_3 = { 8b55a0 52 ff15???????? 8bd0 8d4d98 ff15???????? 50 }
            // n = 7, score = 100
            //   8b55a0               | mov                 edx, dword ptr [ebp - 0x60]
            //   52                   | push                edx
            //   ff15????????         |                     
            //   8bd0                 | mov                 edx, eax
            //   8d4d98               | lea                 ecx, [ebp - 0x68]
            //   ff15????????         |                     
            //   50                   | push                eax

        $sequence_4 = { 6a00 51 50 ff35???????? ff15???????? 85c0 0f8c0b1a0000 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   51                   | push                ecx
            //   50                   | push                eax
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8c0b1a0000         | jl                  0x1a11

        $sequence_5 = { 8b04c5fc201822 8b7824 8b450c 85ff 0f847c340000 8b08 3b0f }
            // n = 7, score = 100
            //   8b04c5fc201822       | mov                 eax, dword ptr [eax*8 + 0x221820fc]
            //   8b7824               | mov                 edi, dword ptr [eax + 0x24]
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   85ff                 | test                edi, edi
            //   0f847c340000         | je                  0x3482
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   3b0f                 | cmp                 ecx, dword ptr [edi]

        $sequence_6 = { ebe5 55 8bec 83ec18 53 56 57 }
            // n = 7, score = 100
            //   ebe5                 | jmp                 0xffffffe7
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec18               | sub                 esp, 0x18
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi

        $sequence_7 = { 8bcf e8???????? 8bf0 8bcb ff760c ff7608 e8???????? }
            // n = 7, score = 100
            //   8bcf                 | mov                 ecx, edi
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   8bcb                 | mov                 ecx, ebx
            //   ff760c               | push                dword ptr [esi + 0xc]
            //   ff7608               | push                dword ptr [esi + 8]
            //   e8????????           |                     

        $sequence_8 = { 8d45d4 50 6a02 ff15???????? 83c40c 8d4dc0 51 }
            // n = 7, score = 100
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   50                   | push                eax
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   83c40c               | add                 esp, 0xc
            //   8d4dc0               | lea                 ecx, [ebp - 0x40]
            //   51                   | push                ecx

        $sequence_9 = { ffb610060000 81c610060000 8bc8 e8???????? ff36 832700 }
            // n = 6, score = 100
            //   ffb610060000         | push                dword ptr [esi + 0x610]
            //   81c610060000         | add                 esi, 0x610
            //   8bc8                 | mov                 ecx, eax
            //   e8????????           |                     
            //   ff36                 | push                dword ptr [esi]
            //   832700               | and                 dword ptr [edi], 0

    condition:
        7 of them and filesize < 499712
}