rule win_zenar_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zenar."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zenar"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b4d8c 51 50 e8???????? 59 }
            // n = 5, score = 100
            //   8b4d8c               | mov                 ecx, dword ptr [ebp - 0x74]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_1 = { 751a 83f8ff 740f 83f8fe 740a 6bcf38 030c9598ae4300 }
            // n = 7, score = 100
            //   751a                 | jne                 0x1c
            //   83f8ff               | cmp                 eax, -1
            //   740f                 | je                  0x11
            //   83f8fe               | cmp                 eax, -2
            //   740a                 | je                  0xc
            //   6bcf38               | imul                ecx, edi, 0x38
            //   030c9598ae4300       | add                 ecx, dword ptr [edx*4 + 0x43ae98]

        $sequence_2 = { 83c801 50 6800000080 ff7508 e8???????? 5d }
            // n = 6, score = 100
            //   83c801               | or                  eax, 1
            //   50                   | push                eax
            //   6800000080           | push                0x80000000
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   5d                   | pop                 ebp

        $sequence_3 = { 56 ff7508 e8???????? 83c40c e9???????? 8b048d98ae4300 807c022800 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   e9????????           |                     
            //   8b048d98ae4300       | mov                 eax, dword ptr [ecx*4 + 0x43ae98]
            //   807c022800           | cmp                 byte ptr [edx + eax + 0x28], 0

        $sequence_4 = { 68???????? eb0c 68???????? eb05 68???????? e8???????? 39be90000000 }
            // n = 7, score = 100
            //   68????????           |                     
            //   eb0c                 | jmp                 0xe
            //   68????????           |                     
            //   eb05                 | jmp                 7
            //   68????????           |                     
            //   e8????????           |                     
            //   39be90000000         | cmp                 dword ptr [esi + 0x90], edi

        $sequence_5 = { 8bf1 57 ff750c 33ff 8975fc 8d4e0c c706???????? }
            // n = 7, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   33ff                 | xor                 edi, edi
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   8d4e0c               | lea                 ecx, [esi + 0xc]
            //   c706????????         |                     

        $sequence_6 = { c3 6857000780 68???????? 8d4df0 e8???????? 68???????? 8d45f0 }
            // n = 7, score = 100
            //   c3                   | ret                 
            //   6857000780           | push                0x80070057
            //   68????????           |                     
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   e8????????           |                     
            //   68????????           |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]

        $sequence_7 = { 8945fc 56 ff750c 8b7508 8d45fa 50 8975c8 }
            // n = 7, score = 100
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   56                   | push                esi
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8d45fa               | lea                 eax, [ebp - 6]
            //   50                   | push                eax
            //   8975c8               | mov                 dword ptr [ebp - 0x38], esi

        $sequence_8 = { 3bfe 72f3 33c0 66890472 8bc3 }
            // n = 5, score = 100
            //   3bfe                 | cmp                 edi, esi
            //   72f3                 | jb                  0xfffffff5
            //   33c0                 | xor                 eax, eax
            //   66890472             | mov                 word ptr [edx + esi*2], ax
            //   8bc3                 | mov                 eax, ebx

        $sequence_9 = { 48 6a5c 5e 8d0442 eb0d 6683f92f 740f }
            // n = 7, score = 100
            //   48                   | dec                 eax
            //   6a5c                 | push                0x5c
            //   5e                   | pop                 esi
            //   8d0442               | lea                 eax, [edx + eax*2]
            //   eb0d                 | jmp                 0xf
            //   6683f92f             | cmp                 cx, 0x2f
            //   740f                 | je                  0x11

    condition:
        7 of them and filesize < 519168
}