rule win_zerot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zerot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zerot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c404 33f6 eb13 6800006000 e8???????? }
            // n = 6, score = 200
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   33f6                 | xor                 esi, esi
            //   eb13                 | jmp                 0x15
            //   6800006000           | push                0x600000
            //   e8????????           |                     

        $sequence_1 = { 6a00 6a00 ff15???????? a3???????? ff15???????? 3db7000000 7527 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   a3????????           |                     
            //   ff15????????         |                     
            //   3db7000000           | cmp                 eax, 0xb7
            //   7527                 | jne                 0x29

        $sequence_2 = { 8b4608 c706???????? 85c0 740a 50 }
            // n = 5, score = 200
            //   8b4608               | mov                 eax, dword ptr [esi + 8]
            //   c706????????         |                     
            //   85c0                 | test                eax, eax
            //   740a                 | je                  0xc
            //   50                   | push                eax

        $sequence_3 = { 83c408 e9???????? 8b8d34fdffff bf???????? 83f904 }
            // n = 5, score = 200
            //   83c408               | add                 esp, 8
            //   e9????????           |                     
            //   8b8d34fdffff         | mov                 ecx, dword ptr [ebp - 0x2cc]
            //   bf????????           |                     
            //   83f904               | cmp                 ecx, 4

        $sequence_4 = { ff7610 6a01 ff760c ff15???????? }
            // n = 4, score = 200
            //   ff7610               | push                dword ptr [esi + 0x10]
            //   6a01                 | push                1
            //   ff760c               | push                dword ptr [esi + 0xc]
            //   ff15????????         |                     

        $sequence_5 = { 6a00 6820020000 6a20 6a02 8d854cfeffff 66c78550feffff0005 50 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   6820020000           | push                0x220
            //   6a20                 | push                0x20
            //   6a02                 | push                2
            //   8d854cfeffff         | lea                 eax, [ebp - 0x1b4]
            //   66c78550feffff0005     | mov    word ptr [ebp - 0x1b0], 0x500
            //   50                   | push                eax

        $sequence_6 = { 7409 50 e8???????? 83c404 33ff c7850cfaffff00000000 32db }
            // n = 7, score = 200
            //   7409                 | je                  0xb
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   33ff                 | xor                 edi, edi
            //   c7850cfaffff00000000     | mov    dword ptr [ebp - 0x5f4], 0
            //   32db                 | xor                 bl, bl

        $sequence_7 = { 6800020000 8d8510fdffff 6a00 50 e8???????? }
            // n = 5, score = 200
            //   6800020000           | push                0x200
            //   8d8510fdffff         | lea                 eax, [ebp - 0x2f0]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_8 = { 8d8524fdffff 50 8d4376 50 6a02 ffd6 8d851cfdffff }
            // n = 7, score = 200
            //   8d8524fdffff         | lea                 eax, [ebp - 0x2dc]
            //   50                   | push                eax
            //   8d4376               | lea                 eax, [ebx + 0x76]
            //   50                   | push                eax
            //   6a02                 | push                2
            //   ffd6                 | call                esi
            //   8d851cfdffff         | lea                 eax, [ebp - 0x2e4]

        $sequence_9 = { ff15???????? 8bc3 be19000000 43 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   8bc3                 | mov                 eax, ebx
            //   be19000000           | mov                 esi, 0x19
            //   43                   | inc                 ebx

    condition:
        7 of them and filesize < 303104
}