rule win_zeus_action_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zeus_action."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zeus_action"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 ff15???????? 89866c070000 85c0 0f849c010000 ff15???????? }
            // n = 6, score = 300
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   89866c070000         | mov                 dword ptr [esi + 0x76c], eax
            //   85c0                 | test                eax, eax
            //   0f849c010000         | je                  0x1a2
            //   ff15????????         |                     

        $sequence_1 = { 59 ebb1 8365fc00 8d45fc 50 56 e8???????? }
            // n = 7, score = 300
            //   59                   | pop                 ecx
            //   ebb1                 | jmp                 0xffffffb3
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_2 = { 50 ffd6 8b4304 83c40c 83400403 e9???????? 8d4df8 }
            // n = 7, score = 300
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   83c40c               | add                 esp, 0xc
            //   83400403             | add                 dword ptr [eax + 4], 3
            //   e9????????           |                     
            //   8d4df8               | lea                 ecx, [ebp - 8]

        $sequence_3 = { c3 55 8bec 33d2 837d1008 53 8ada }
            // n = 7, score = 300
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   33d2                 | xor                 edx, edx
            //   837d1008             | cmp                 dword ptr [ebp + 0x10], 8
            //   53                   | push                ebx
            //   8ada                 | mov                 bl, dl

        $sequence_4 = { ff15???????? 89442420 0fb705???????? 50 ff15???????? 668944241e 6a10 }
            // n = 7, score = 300
            //   ff15????????         |                     
            //   89442420             | mov                 dword ptr [esp + 0x20], eax
            //   0fb705????????       |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   668944241e           | mov                 word ptr [esp + 0x1e], ax
            //   6a10                 | push                0x10

        $sequence_5 = { 75e6 8b55e8 8b7508 8b7d0c 8b4510 eb05 }
            // n = 6, score = 300
            //   75e6                 | jne                 0xffffffe8
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   eb05                 | jmp                 7

        $sequence_6 = { 8b3f 8b4f0c 8b5f08 894dfc 8b45f8 3b7df4 0f85ebfeffff }
            // n = 7, score = 300
            //   8b3f                 | mov                 edi, dword ptr [edi]
            //   8b4f0c               | mov                 ecx, dword ptr [edi + 0xc]
            //   8b5f08               | mov                 ebx, dword ptr [edi + 8]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   3b7df4               | cmp                 edi, dword ptr [ebp - 0xc]
            //   0f85ebfeffff         | jne                 0xfffffef1

        $sequence_7 = { 3bc1 7e04 33c0 eb37 8b4d18 0fb73b 8b11 }
            // n = 7, score = 300
            //   3bc1                 | cmp                 eax, ecx
            //   7e04                 | jle                 6
            //   33c0                 | xor                 eax, eax
            //   eb37                 | jmp                 0x39
            //   8b4d18               | mov                 ecx, dword ptr [ebp + 0x18]
            //   0fb73b               | movzx               edi, word ptr [ebx]
            //   8b11                 | mov                 edx, dword ptr [ecx]

        $sequence_8 = { eb76 80f96e 7523 8b4304 8b4804 8b5008 2bd1 }
            // n = 7, score = 300
            //   eb76                 | jmp                 0x78
            //   80f96e               | cmp                 cl, 0x6e
            //   7523                 | jne                 0x25
            //   8b4304               | mov                 eax, dword ptr [ebx + 4]
            //   8b4804               | mov                 ecx, dword ptr [eax + 4]
            //   8b5008               | mov                 edx, dword ptr [eax + 8]
            //   2bd1                 | sub                 edx, ecx

        $sequence_9 = { 8945e4 85c0 0f849f010000 8b4508 8bf8 c1ef06 a83f }
            // n = 7, score = 300
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   85c0                 | test                eax, eax
            //   0f849f010000         | je                  0x1a5
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8bf8                 | mov                 edi, eax
            //   c1ef06               | shr                 edi, 6
            //   a83f                 | test                al, 0x3f

    condition:
        7 of them and filesize < 827392
}