rule win_zeus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zeus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zeus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb58 833f00 7651 8b5f08 }
            // n = 4, score = 700
            //   eb58                 | jmp                 0x5a
            //   833f00               | cmp                 dword ptr [edi], 0
            //   7651                 | jbe                 0x53
            //   8b5f08               | mov                 ebx, dword ptr [edi + 8]

        $sequence_1 = { 8d461c 50 8d45f0 50 e8???????? 6a10 8d460c }
            // n = 7, score = 600
            //   8d461c               | lea                 eax, [esi + 0x1c]
            //   50                   | push                eax
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   e8????????           |                     
            //   6a10                 | push                0x10
            //   8d460c               | lea                 eax, [esi + 0xc]

        $sequence_2 = { 8d461c 50 8d460c 50 e8???????? }
            // n = 5, score = 600
            //   8d461c               | lea                 eax, [esi + 0x1c]
            //   50                   | push                eax
            //   8d460c               | lea                 eax, [esi + 0xc]
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_3 = { 8d440810 8bc8 2bca 8b12 }
            // n = 4, score = 600
            //   8d440810             | lea                 eax, [eax + ecx + 0x10]
            //   8bc8                 | mov                 ecx, eax
            //   2bca                 | sub                 ecx, edx
            //   8b12                 | mov                 edx, dword ptr [edx]

        $sequence_4 = { 8d460c 8d4df0 e8???????? f7d8 1ac0 fec0 c9 }
            // n = 7, score = 600
            //   8d460c               | lea                 eax, [esi + 0xc]
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   e8????????           |                     
            //   f7d8                 | neg                 eax
            //   1ac0                 | sbb                 al, al
            //   fec0                 | inc                 al
            //   c9                   | leave               

        $sequence_5 = { 85c0 7438 83600400 8918 8b4e08 }
            // n = 5, score = 600
            //   85c0                 | test                eax, eax
            //   7438                 | je                  0x3a
            //   83600400             | and                 dword ptr [eax + 4], 0
            //   8918                 | mov                 dword ptr [eax], ebx
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]

        $sequence_6 = { 8906 85ff 760c 8b550c }
            // n = 4, score = 600
            //   8906                 | mov                 dword ptr [esi], eax
            //   85ff                 | test                edi, edi
            //   760c                 | jbe                 0xe
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]

        $sequence_7 = { 83f801 7516 51 e8???????? }
            // n = 4, score = 600
            //   83f801               | cmp                 eax, 1
            //   7516                 | jne                 0x18
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_8 = { 8bf3 6810270000 ff35???????? ff15???????? }
            // n = 4, score = 500
            //   8bf3                 | mov                 esi, ebx
            //   6810270000           | push                0x2710
            //   ff35????????         |                     
            //   ff15????????         |                     

        $sequence_9 = { 891d???????? 891d???????? ffd6 68???????? }
            // n = 4, score = 500
            //   891d????????         |                     
            //   891d????????         |                     
            //   ffd6                 | call                esi
            //   68????????           |                     

        $sequence_10 = { e8???????? 84c0 7442 6a10 }
            // n = 4, score = 500
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   7442                 | je                  0x44
            //   6a10                 | push                0x10

        $sequence_11 = { 8d8db0fdffff e8???????? 8ad8 84db }
            // n = 4, score = 400
            //   8d8db0fdffff         | lea                 ecx, [ebp - 0x250]
            //   e8????????           |                     
            //   8ad8                 | mov                 bl, al
            //   84db                 | test                bl, bl

        $sequence_12 = { c20400 55 8bec f6451802 }
            // n = 4, score = 300
            //   c20400               | ret                 4
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   f6451802             | test                byte ptr [ebp + 0x18], 2

        $sequence_13 = { ff15???????? 5e 8ac3 5b c20800 55 }
            // n = 6, score = 300
            //   ff15????????         |                     
            //   5e                   | pop                 esi
            //   8ac3                 | mov                 al, bl
            //   5b                   | pop                 ebx
            //   c20800               | ret                 8
            //   55                   | push                ebp

        $sequence_14 = { b364 6a14 eb18 81fb5a5c4156 }
            // n = 4, score = 200
            //   b364                 | mov                 bl, 0x64
            //   6a14                 | push                0x14
            //   eb18                 | jmp                 0x1a
            //   81fb5a5c4156         | cmp                 ebx, 0x56415c5a

        $sequence_15 = { 8d470c 50 c707000e0000 c7470809080002 e8???????? 83674200 6a78 }
            // n = 7, score = 200
            //   8d470c               | lea                 eax, [edi + 0xc]
            //   50                   | push                eax
            //   c707000e0000         | mov                 dword ptr [edi], 0xe00
            //   c7470809080002       | mov                 dword ptr [edi + 8], 0x2000809
            //   e8????????           |                     
            //   83674200             | and                 dword ptr [edi + 0x42], 0
            //   6a78                 | push                0x78

        $sequence_16 = { 3509080002 3d5c5b4550 740b 3d59495351 0f85ca000000 807b0420 0f85c0000000 }
            // n = 7, score = 200
            //   3509080002           | xor                 eax, 0x2000809
            //   3d5c5b4550           | cmp                 eax, 0x50455b5c
            //   740b                 | je                  0xd
            //   3d59495351           | cmp                 eax, 0x51534959
            //   0f85ca000000         | jne                 0xd0
            //   807b0420             | cmp                 byte ptr [ebx + 4], 0x20
            //   0f85c0000000         | jne                 0xc6

        $sequence_17 = { 0f873d020000 83fe06 0f86e3000000 8b03 3509080002 3d5c5b4550 740b }
            // n = 7, score = 200
            //   0f873d020000         | ja                  0x243
            //   83fe06               | cmp                 esi, 6
            //   0f86e3000000         | jbe                 0xe9
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   3509080002           | xor                 eax, 0x2000809
            //   3d5c5b4550           | cmp                 eax, 0x50455b5c
            //   740b                 | je                  0xd

        $sequence_18 = { 68???????? 6809080002 8bc6 50 8d45fc }
            // n = 5, score = 200
            //   68????????           |                     
            //   6809080002           | push                0x2000809
            //   8bc6                 | mov                 eax, esi
            //   50                   | push                eax
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_19 = { 56 68???????? ff750c 51 ff7508 ff15???????? 8bf8 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   68????????           |                     
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   51                   | push                ecx
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax

        $sequence_20 = { 8d75a8 b8d5000000 e8???????? 68e6010000 68???????? 6809080002 }
            // n = 6, score = 200
            //   8d75a8               | lea                 esi, [ebp - 0x58]
            //   b8d5000000           | mov                 eax, 0xd5
            //   e8????????           |                     
            //   68e6010000           | push                0x1e6
            //   68????????           |                     
            //   6809080002           | push                0x2000809

        $sequence_21 = { 6813270000 6a04 5b 8bc6 c745f809080002 e8???????? 8ad8 }
            // n = 7, score = 200
            //   6813270000           | push                0x2713
            //   6a04                 | push                4
            //   5b                   | pop                 ebx
            //   8bc6                 | mov                 eax, esi
            //   c745f809080002       | mov                 dword ptr [ebp - 8], 0x2000809
            //   e8????????           |                     
            //   8ad8                 | mov                 bl, al

        $sequence_22 = { 807b0244 7429 83fe04 0f82ec000000 8b1b 81f309080002 }
            // n = 6, score = 200
            //   807b0244             | cmp                 byte ptr [ebx + 2], 0x44
            //   7429                 | je                  0x2b
            //   83fe04               | cmp                 esi, 4
            //   0f82ec000000         | jb                  0xf2
            //   8b1b                 | mov                 ebx, dword ptr [ebx]
            //   81f309080002         | xor                 ebx, 0x2000809

    condition:
        7 of them and filesize < 319488
}