rule win_zeus_mailsniffer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zeus_mailsniffer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zeus_mailsniffer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 81ec1c020000 56 6a1c 58 8945f0 c745f4c89d2d01 8945f8 }
            // n = 7, score = 100
            //   81ec1c020000         | sub                 esp, 0x21c
            //   56                   | push                esi
            //   6a1c                 | push                0x1c
            //   58                   | pop                 eax
            //   8945f0               | mov                 dword ptr [ebp - 0x10], eax
            //   c745f4c89d2d01       | mov                 dword ptr [ebp - 0xc], 0x12d9dc8
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_1 = { 0f8486000000 6a10 58 e8???????? 8bf0 85f6 }
            // n = 6, score = 100
            //   0f8486000000         | je                  0x8c
            //   6a10                 | push                0x10
            //   58                   | pop                 eax
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

        $sequence_2 = { e8???????? 83c40c 833e00 894608 897e0c 7421 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   833e00               | cmp                 dword ptr [esi], 0
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   897e0c               | mov                 dword ptr [esi + 0xc], edi
            //   7421                 | je                  0x23

        $sequence_3 = { 8b4508 8b4dec c745f451000000 8908 83ff17 750f }
            // n = 6, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   c745f451000000       | mov                 dword ptr [ebp - 0xc], 0x51
            //   8908                 | mov                 dword ptr [eax], ecx
            //   83ff17               | cmp                 edi, 0x17
            //   750f                 | jne                 0x11

        $sequence_4 = { e8???????? 57 68???????? 57 e8???????? 83c424 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   57                   | push                edi
            //   68????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c424               | add                 esp, 0x24

        $sequence_5 = { 85c0 0f8498010000 8b45f4 8365c800 83c004 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   0f8498010000         | je                  0x19e
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8365c800             | and                 dword ptr [ebp - 0x38], 0
            //   83c004               | add                 eax, 4

        $sequence_6 = { 57 8d85ecfeffff 50 53 8d85b4faffff }
            // n = 5, score = 100
            //   57                   | push                edi
            //   8d85ecfeffff         | lea                 eax, [ebp - 0x114]
            //   50                   | push                eax
            //   53                   | push                ebx
            //   8d85b4faffff         | lea                 eax, [ebp - 0x54c]

        $sequence_7 = { ff15???????? ffb424f4040000 ff15???????? 8b8424cc040000 }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   ffb424f4040000       | push                dword ptr [esp + 0x4f4]
            //   ff15????????         |                     
            //   8b8424cc040000       | mov                 eax, dword ptr [esp + 0x4cc]

        $sequence_8 = { 83c410 85ff 742c 8b462c ff7608 ff7628 85c0 }
            // n = 7, score = 100
            //   83c410               | add                 esp, 0x10
            //   85ff                 | test                edi, edi
            //   742c                 | je                  0x2e
            //   8b462c               | mov                 eax, dword ptr [esi + 0x2c]
            //   ff7608               | push                dword ptr [esi + 8]
            //   ff7628               | push                dword ptr [esi + 0x28]
            //   85c0                 | test                eax, eax

        $sequence_9 = { 743f 66833f00 7439 56 6a16 8d75e4 58 }
            // n = 7, score = 100
            //   743f                 | je                  0x41
            //   66833f00             | cmp                 word ptr [edi], 0
            //   7439                 | je                  0x3b
            //   56                   | push                esi
            //   6a16                 | push                0x16
            //   8d75e4               | lea                 esi, [ebp - 0x1c]
            //   58                   | pop                 eax

    condition:
        7 of them and filesize < 368640
}