rule win_zhcat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zhcat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zhcat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff7510 668945c6 ffd7 8b3d???????? 8945c8 8b45fc 33f6 }
            // n = 7, score = 200
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   668945c6             | mov                 word ptr [ebp - 0x3a], ax
            //   ffd7                 | call                edi
            //   8b3d????????         |                     
            //   8945c8               | mov                 dword ptr [ebp - 0x38], eax
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   33f6                 | xor                 esi, esi

        $sequence_1 = { e8???????? a1???????? 59 803d????????00 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   a1????????           |                     
            //   59                   | pop                 ecx
            //   803d????????00       |                     

        $sequence_2 = { 8d45d4 50 8d45ec 50 33db 8d45f8 }
            // n = 6, score = 200
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   50                   | push                eax
            //   8d45ec               | lea                 eax, [ebp - 0x14]
            //   50                   | push                eax
            //   33db                 | xor                 ebx, ebx
            //   8d45f8               | lea                 eax, [ebp - 8]

        $sequence_3 = { 8bc6 c1f805 8b048540604100 83e61f c1e606 59 c644300400 }
            // n = 7, score = 200
            //   8bc6                 | mov                 eax, esi
            //   c1f805               | sar                 eax, 5
            //   8b048540604100       | mov                 eax, dword ptr [eax*4 + 0x416040]
            //   83e61f               | and                 esi, 0x1f
            //   c1e606               | shl                 esi, 6
            //   59                   | pop                 ecx
            //   c644300400           | mov                 byte ptr [eax + esi + 4], 0

        $sequence_4 = { 7506 394c2418 742c c705????????01000000 eb20 8b450c }
            // n = 6, score = 200
            //   7506                 | jne                 8
            //   394c2418             | cmp                 dword ptr [esp + 0x18], ecx
            //   742c                 | je                  0x2e
            //   c705????????01000000     |     
            //   eb20                 | jmp                 0x22
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_5 = { ffd7 6a02 8945d8 58 ff7514 668945c4 ffd6 }
            // n = 7, score = 200
            //   ffd7                 | call                edi
            //   6a02                 | push                2
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   58                   | pop                 eax
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   668945c4             | mov                 word ptr [ebp - 0x3c], ax
            //   ffd6                 | call                esi

        $sequence_6 = { c3 8bff 56 57 33ff ffb7004e4100 ff15???????? }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   8bff                 | mov                 edi, edi
            //   56                   | push                esi
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   ffb7004e4100         | push                dword ptr [edi + 0x414e00]
            //   ff15????????         |                     

        $sequence_7 = { 3b04cd20434100 7413 41 83f92d 72f1 }
            // n = 5, score = 200
            //   3b04cd20434100       | cmp                 eax, dword ptr [ecx*8 + 0x414320]
            //   7413                 | je                  0x15
            //   41                   | inc                 ecx
            //   83f92d               | cmp                 ecx, 0x2d
            //   72f1                 | jb                  0xfffffff3

        $sequence_8 = { e8???????? 8b45f8 8b4dfc 83c40c 894104 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   83c40c               | add                 esp, 0xc
            //   894104               | mov                 dword ptr [ecx + 4], eax

        $sequence_9 = { 7407 68???????? ebd3 39742418 7507 68???????? ebc6 }
            // n = 7, score = 200
            //   7407                 | je                  9
            //   68????????           |                     
            //   ebd3                 | jmp                 0xffffffd5
            //   39742418             | cmp                 dword ptr [esp + 0x18], esi
            //   7507                 | jne                 9
            //   68????????           |                     
            //   ebc6                 | jmp                 0xffffffc8

    condition:
        7 of them and filesize < 376832
}