rule win_zitmo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zitmo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zitmo"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 23cb 8bd6 ff75a0 e8???????? }
            // n = 4, score = 200
            //   23cb                 | and                 ecx, ebx
            //   8bd6                 | mov                 edx, esi
            //   ff75a0               | push                dword ptr [ebp - 0x60]
            //   e8????????           |                     

        $sequence_1 = { 55 8bec 81c434ffffff f7df 8bf0 49 }
            // n = 6, score = 200
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81c434ffffff         | add                 esp, 0xffffff34
            //   f7df                 | neg                 edi
            //   8bf0                 | mov                 esi, eax
            //   49                   | dec                 ecx

        $sequence_2 = { 8175b437340000 23f9 f7d1 03d7 f7d2 }
            // n = 5, score = 200
            //   8175b437340000       | xor                 dword ptr [ebp - 0x4c], 0x3437
            //   23f9                 | and                 edi, ecx
            //   f7d1                 | not                 ecx
            //   03d7                 | add                 edx, edi
            //   f7d2                 | not                 edx

        $sequence_3 = { 4b f7de c745bc36343335 03c3 f7da f7d1 }
            // n = 6, score = 200
            //   4b                   | dec                 ebx
            //   f7de                 | neg                 esi
            //   c745bc36343335       | mov                 dword ptr [ebp - 0x44], 0x35333436
            //   03c3                 | add                 eax, ebx
            //   f7da                 | neg                 edx
            //   f7d1                 | not                 ecx

        $sequence_4 = { ffb584feffff 56 e8???????? ffb574ffffff }
            // n = 4, score = 200
            //   ffb584feffff         | push                dword ptr [ebp - 0x17c]
            //   56                   | push                esi
            //   e8????????           |                     
            //   ffb574ffffff         | push                dword ptr [ebp - 0x8c]

        $sequence_5 = { f7df 894da8 8955d0 ffb560feffff e8???????? c9 }
            // n = 6, score = 200
            //   f7df                 | neg                 edi
            //   894da8               | mov                 dword ptr [ebp - 0x58], ecx
            //   8955d0               | mov                 dword ptr [ebp - 0x30], edx
            //   ffb560feffff         | push                dword ptr [ebp - 0x1a0]
            //   e8????????           |                     
            //   c9                   | leave               

        $sequence_6 = { f7d7 ff45b4 8bcf f7d6 03fa 8d9568ffffff }
            // n = 6, score = 200
            //   f7d7                 | not                 edi
            //   ff45b4               | inc                 dword ptr [ebp - 0x4c]
            //   8bcf                 | mov                 ecx, edi
            //   f7d6                 | not                 esi
            //   03fa                 | add                 edi, edx
            //   8d9568ffffff         | lea                 edx, [ebp - 0x98]

        $sequence_7 = { 81759437320000 3145b8 41 23c6 }
            // n = 4, score = 200
            //   81759437320000       | xor                 dword ptr [ebp - 0x6c], 0x3237
            //   3145b8               | xor                 dword ptr [ebp - 0x48], eax
            //   41                   | inc                 ecx
            //   23c6                 | and                 eax, esi

        $sequence_8 = { 42 4e f7df 03d7 48 40 }
            // n = 6, score = 200
            //   42                   | inc                 edx
            //   4e                   | dec                 esi
            //   f7df                 | neg                 edi
            //   03d7                 | add                 edx, edi
            //   48                   | dec                 eax
            //   40                   | inc                 eax

        $sequence_9 = { 23cb 4a f7d0 8955c4 c9 c20c00 55 }
            // n = 7, score = 200
            //   23cb                 | and                 ecx, ebx
            //   4a                   | dec                 edx
            //   f7d0                 | not                 eax
            //   8955c4               | mov                 dword ptr [ebp - 0x3c], edx
            //   c9                   | leave               
            //   c20c00               | ret                 0xc
            //   55                   | push                ebp

    condition:
        7 of them and filesize < 843776
}