rule win_ziyangrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ziyangrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ziyangrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 8dbc2421140000 889c2420140000 f3ab }
            // n = 4, score = 200
            //   33c0                 | xor                 eax, eax
            //   8dbc2421140000       | lea                 edi, [esp + 0x1421]
            //   889c2420140000       | mov                 byte ptr [esp + 0x1420], bl
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_1 = { 50 ff15???????? 85c0 751d ff15???????? 50 56 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   751d                 | jne                 0x1f
            //   ff15????????         |                     
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_2 = { 7560 55 6800040000 ff15???????? 55 8d842468010000 }
            // n = 6, score = 200
            //   7560                 | jne                 0x62
            //   55                   | push                ebp
            //   6800040000           | push                0x400
            //   ff15????????         |                     
            //   55                   | push                ebp
            //   8d842468010000       | lea                 eax, [esp + 0x168]

        $sequence_3 = { 0f841b010000 81fe4c4f0000 0f87e6000000 8b4c2424 8d542414 83e110 }
            // n = 6, score = 200
            //   0f841b010000         | je                  0x121
            //   81fe4c4f0000         | cmp                 esi, 0x4f4c
            //   0f87e6000000         | ja                  0xec
            //   8b4c2424             | mov                 ecx, dword ptr [esp + 0x24]
            //   8d542414             | lea                 edx, [esp + 0x14]
            //   83e110               | and                 ecx, 0x10

        $sequence_4 = { 33c0 8d7c2409 8bb4240c040000 f3ab 66ab 56 6a00 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   8d7c2409             | lea                 edi, [esp + 9]
            //   8bb4240c040000       | mov                 esi, dword ptr [esp + 0x40c]
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   56                   | push                esi
            //   6a00                 | push                0

        $sequence_5 = { 7e95 ffd5 8bf0 89742430 }
            // n = 4, score = 200
            //   7e95                 | jle                 0xffffff97
            //   ffd5                 | call                ebp
            //   8bf0                 | mov                 esi, eax
            //   89742430             | mov                 dword ptr [esp + 0x30], esi

        $sequence_6 = { 83f810 0f85a6000000 8b7304 81fe00500000 0f8f97000000 85f6 0f8c8f000000 }
            // n = 7, score = 200
            //   83f810               | cmp                 eax, 0x10
            //   0f85a6000000         | jne                 0xac
            //   8b7304               | mov                 esi, dword ptr [ebx + 4]
            //   81fe00500000         | cmp                 esi, 0x5000
            //   0f8f97000000         | jg                  0x9d
            //   85f6                 | test                esi, esi
            //   0f8c8f000000         | jl                  0x95

        $sequence_7 = { 33c0 8dbc2411010000 889c2410010000 f3ab 66ab aa b91f000000 }
            // n = 7, score = 200
            //   33c0                 | xor                 eax, eax
            //   8dbc2411010000       | lea                 edi, [esp + 0x111]
            //   889c2410010000       | mov                 byte ptr [esp + 0x110], bl
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   aa                   | stosb               byte ptr es:[edi], al
            //   b91f000000           | mov                 ecx, 0x1f

        $sequence_8 = { 8db424c0190000 f2ae f7d1 49 bf???????? 8bd1 c1e902 }
            // n = 7, score = 200
            //   8db424c0190000       | lea                 esi, [esp + 0x19c0]
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   49                   | dec                 ecx
            //   bf????????           |                     
            //   8bd1                 | mov                 edx, ecx
            //   c1e902               | shr                 ecx, 2

        $sequence_9 = { 50 c68424fb00000061 c68424fc00000074 c68424fd00000061 889c24fe000000 c684240801000053 c684240901000079 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   c68424fb00000061     | mov                 byte ptr [esp + 0xfb], 0x61
            //   c68424fc00000074     | mov                 byte ptr [esp + 0xfc], 0x74
            //   c68424fd00000061     | mov                 byte ptr [esp + 0xfd], 0x61
            //   889c24fe000000       | mov                 byte ptr [esp + 0xfe], bl
            //   c684240801000053     | mov                 byte ptr [esp + 0x108], 0x53
            //   c684240901000079     | mov                 byte ptr [esp + 0x109], 0x79

    condition:
        7 of them and filesize < 188416
}