rule win_zlob_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zlob."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zlob"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8944241c c70424e8030000 e9???????? ffd3 ffd3 ffd6 }
            // n = 6, score = 200
            //   8944241c             | mov                 dword ptr [esp + 0x1c], eax
            //   c70424e8030000       | mov                 dword ptr [esp], 0x3e8
            //   e9????????           |                     
            //   ffd3                 | call                ebx
            //   ffd3                 | call                ebx
            //   ffd6                 | call                esi

        $sequence_1 = { 0f8436010000 ffd5 ffd5 ffd6 ffd7 }
            // n = 5, score = 200
            //   0f8436010000         | je                  0x13c
            //   ffd5                 | call                ebp
            //   ffd5                 | call                ebp
            //   ffd6                 | call                esi
            //   ffd7                 | call                edi

        $sequence_2 = { ffd7 ffd6 ffd7 ffd6 ffd6 ffd7 8d842440020000 }
            // n = 7, score = 200
            //   ffd7                 | call                edi
            //   ffd6                 | call                esi
            //   ffd7                 | call                edi
            //   ffd6                 | call                esi
            //   ffd6                 | call                esi
            //   ffd7                 | call                edi
            //   8d842440020000       | lea                 eax, [esp + 0x240]

        $sequence_3 = { 50 ffd6 85c0 750d 6a08 6a01 57 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   85c0                 | test                eax, eax
            //   750d                 | jne                 0xf
            //   6a08                 | push                8
            //   6a01                 | push                1
            //   57                   | push                edi

        $sequence_4 = { c685f5fdffff31 c685f6fdffff65 c685f7fdffff30 c685f8fdffff2d c685f9fdffff64 c685fafdffff65 }
            // n = 6, score = 200
            //   c685f5fdffff31       | mov                 byte ptr [ebp - 0x20b], 0x31
            //   c685f6fdffff65       | mov                 byte ptr [ebp - 0x20a], 0x65
            //   c685f7fdffff30       | mov                 byte ptr [ebp - 0x209], 0x30
            //   c685f8fdffff2d       | mov                 byte ptr [ebp - 0x208], 0x2d
            //   c685f9fdffff64       | mov                 byte ptr [ebp - 0x207], 0x64
            //   c685fafdffff65       | mov                 byte ptr [ebp - 0x206], 0x65

        $sequence_5 = { 8d4c242c e8???????? 8b442448 89442410 eb05 834c2410ff 8d4c241c }
            // n = 7, score = 200
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]
            //   e8????????           |                     
            //   8b442448             | mov                 eax, dword ptr [esp + 0x48]
            //   89442410             | mov                 dword ptr [esp + 0x10], eax
            //   eb05                 | jmp                 7
            //   834c2410ff           | or                  dword ptr [esp + 0x10], 0xffffffff
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]

        $sequence_6 = { 742e 6a03 ff75f0 ff15???????? 85c0 751f 6a03 }
            // n = 7, score = 200
            //   742e                 | je                  0x30
            //   6a03                 | push                3
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   751f                 | jne                 0x21
            //   6a03                 | push                3

        $sequence_7 = { c644241301 ff742414 ff15???????? 8b3d???????? ff742418 ff15???????? }
            // n = 6, score = 200
            //   c644241301           | mov                 byte ptr [esp + 0x13], 1
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   ff15????????         |                     
            //   8b3d????????         |                     
            //   ff742418             | push                dword ptr [esp + 0x18]
            //   ff15????????         |                     

        $sequence_8 = { 6a0c a3???????? e8???????? 59 85c0 }
            // n = 5, score = 200
            //   6a0c                 | push                0xc
            //   a3????????           |                     
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

        $sequence_9 = { 895104 e8???????? c20400 56 57 8b7c240c 8bc7 }
            // n = 7, score = 200
            //   895104               | mov                 dword ptr [ecx + 4], edx
            //   e8????????           |                     
            //   c20400               | ret                 4
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7c240c             | mov                 edi, dword ptr [esp + 0xc]
            //   8bc7                 | mov                 eax, edi

    condition:
        7 of them and filesize < 98304
}