rule win_zxxz_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.zxxz."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.zxxz"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd3 e8???????? 6830750000 ffd3 6a01 6a00 }
            // n = 6, score = 100
            //   ffd3                 | call                ebx
            //   e8????????           |                     
            //   6830750000           | push                0x7530
            //   ffd3                 | call                ebx
            //   6a01                 | push                1
            //   6a00                 | push                0

        $sequence_1 = { 68fa000000 50 ffd5 83c40c 68???????? 8d4c2414 }
            // n = 6, score = 100
            //   68fa000000           | push                0xfa
            //   50                   | push                eax
            //   ffd5                 | call                ebp
            //   83c40c               | add                 esp, 0xc
            //   68????????           |                     
            //   8d4c2414             | lea                 ecx, [esp + 0x14]

        $sequence_2 = { c605????????01 6830750000 ffd3 68???????? }
            // n = 4, score = 100
            //   c605????????01       |                     
            //   6830750000           | push                0x7530
            //   ffd3                 | call                ebx
            //   68????????           |                     

        $sequence_3 = { c20400 8bfe 83cf0f 81ffffffff7f 7627 }
            // n = 5, score = 100
            //   c20400               | ret                 4
            //   8bfe                 | mov                 edi, esi
            //   83cf0f               | or                  edi, 0xf
            //   81ffffffff7f         | cmp                 edi, 0x7fffffff
            //   7627                 | jbe                 0x29

        $sequence_4 = { 8d4c2430 c744241401000000 c644242400 ff15???????? 8bc5 8b4c241c }
            // n = 6, score = 100
            //   8d4c2430             | lea                 ecx, [esp + 0x30]
            //   c744241401000000     | mov                 dword ptr [esp + 0x14], 1
            //   c644242400           | mov                 byte ptr [esp + 0x24], 0
            //   ff15????????         |                     
            //   8bc5                 | mov                 eax, ebp
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]

        $sequence_5 = { 83c404 e8???????? 803d????????00 7435 33c0 68fe1f0000 }
            // n = 6, score = 100
            //   83c404               | add                 esp, 4
            //   e8????????           |                     
            //   803d????????00       |                     
            //   7435                 | je                  0x37
            //   33c0                 | xor                 eax, eax
            //   68fe1f0000           | push                0x1ffe

        $sequence_6 = { ff7508 8945f4 6a00 68e9fd0000 ffd0 }
            // n = 5, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   6a00                 | push                0
            //   68e9fd0000           | push                0xfde9
            //   ffd0                 | call                eax

        $sequence_7 = { 51 ff55ec 83c404 8bc6 8bcf 8901 }
            // n = 6, score = 100
            //   51                   | push                ecx
            //   ff55ec               | call                dword ptr [ebp - 0x14]
            //   83c404               | add                 esp, 4
            //   8bc6                 | mov                 eax, esi
            //   8bcf                 | mov                 ecx, edi
            //   8901                 | mov                 dword ptr [ecx], eax

        $sequence_8 = { 6a01 6a01 68???????? ffd7 a1???????? 2bc3 }
            // n = 6, score = 100
            //   6a01                 | push                1
            //   6a01                 | push                1
            //   68????????           |                     
            //   ffd7                 | call                edi
            //   a1????????           |                     
            //   2bc3                 | sub                 eax, ebx

        $sequence_9 = { 8b01 ff5004 c745fcffffffff 8b9558feffff 83c2f0 }
            // n = 5, score = 100
            //   8b01                 | mov                 eax, dword ptr [ecx]
            //   ff5004               | call                dword ptr [eax + 4]
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   8b9558feffff         | mov                 edx, dword ptr [ebp - 0x1a8]
            //   83c2f0               | add                 edx, -0x10

        $sequence_10 = { eb23 03c8 c744241c01000000 83fa02 770c 8079fe3d 7506 }
            // n = 7, score = 100
            //   eb23                 | jmp                 0x25
            //   03c8                 | add                 ecx, eax
            //   c744241c01000000     | mov                 dword ptr [esp + 0x1c], 1
            //   83fa02               | cmp                 edx, 2
            //   770c                 | ja                  0xe
            //   8079fe3d             | cmp                 byte ptr [ecx - 2], 0x3d
            //   7506                 | jne                 8

        $sequence_11 = { 33c0 68f8000000 8bd9 50 }
            // n = 4, score = 100
            //   33c0                 | xor                 eax, eax
            //   68f8000000           | push                0xf8
            //   8bd9                 | mov                 ebx, ecx
            //   50                   | push                eax

        $sequence_12 = { c705????????1cb94000 7410 a1???????? 85c0 7407 50 }
            // n = 6, score = 100
            //   c705????????1cb94000     |     
            //   7410                 | je                  0x12
            //   a1????????           |                     
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   50                   | push                eax

        $sequence_13 = { 85c0 0f84ef000000 eb06 8bc7 8930 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   0f84ef000000         | je                  0xf5
            //   eb06                 | jmp                 8
            //   8bc7                 | mov                 eax, edi
            //   8930                 | mov                 dword ptr [eax], esi

        $sequence_14 = { 8bc6 8931 6a00 6a00 53 }
            // n = 5, score = 100
            //   8bc6                 | mov                 eax, esi
            //   8931                 | mov                 dword ptr [ecx], esi
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 4142080
}